<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Version;


use Moto\Config;
use Moto\System;
use MotoStore\Update\Schema\AbstractSchema;

class Sample extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
    }

    /**
     * Import new Data
     *u
     * @return mixed
     */
    public function import ()
    {
        $this->importSampleData ();
        $translationUpdate = new Update_113 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_121 ($this->getEntityManager ());
        $translationUpdate->updateTranslation();
        $translationUpdate = new Update_129 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $optionsUpdate = new Update_130 ($this->getEntityManager ());
        $optionsUpdate->updateOptions ();
        $translationUpdate = new Update_136 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_137 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_140 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_142 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_145 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $translationUpdate = new Update_146 ($this->getEntityManager ());
        $translationUpdate->addTranslation ();
        $settingsUpdate = new Update_149 ($this->getEntityManager ());
        $settingsUpdate->addSettings ();
    }

    /**
     * Import sample data
     */
    public function importSampleData ()
    {
        $dump = $this->getThemeDataPath ();

        if (!empty ($dump))
        {
            // theme demo data
            $this->sample ($dump);
        }
        else
        {
            // store demo data
            $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample.sql');
        }
    }

    /**
     * theme sample data
     */
    protected function getThemeDataPath ()
    {
        $themeSamplePath = System::getAbsolutePath('@themes')
            . '/'
            . Config::get('settings.website.theme')
            . '/data/plugin/moto-store-plugin/data.sql';

        return file_exists ($themeSamplePath) ? $themeSamplePath : '';
    }
}