<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_113 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $this->fixSettingsTable();
        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Option'),
            $this->entityManager->getClassMetadata ('MotoStore\Settings\Entity\Tax\Rate'),
        );

        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }

    public function addTranslation ()
    {
        /** @var Option $option */
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['SEARCH_RESULT_FOR']))
            {
                $localization ['SEARCH_RESULT_FOR'] = 'Search result for';
            }

            if (!isset ($localization ['PRODUCT_PROPERTIES_BRAND']))
            {
                $localization ['PRODUCT_PROPERTIES_BRAND'] = 'Brand:';
            }

            if (!isset ($localization ['PRODUCT_PROPERTIES_SKU']))
            {
                $localization ['PRODUCT_PROPERTIES_SKU'] = 'SKU:';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();
        }


    }
    
    private function fixSettingsTable ()
    {
        $prefix = $this->entityManager->getTablePrefix ();
        $t =  $prefix . 'store_option';
        $sql = sprintf ("DELETE FROM " .  $t  .  " USING " .  $t  .  ", " .  $t  .  " so WHERE " .  $t  .  ".id > so.id AND " .  $t  .  ".module_name = so.module_name AND " .  $t  .  ".option_key=so.option_key", $t);

        $statement = $this->entityManager->getConnection()->prepare ($sql);
        $statement->execute ();
    }

    /**
     * Import new Data
     *u
     * @return mixed
     */
    public function import ()
    {
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_113.sql');
        $this->addTranslation ();
    }
}