<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_129 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Order\Entity\Order'),
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }


    public function addTranslation ()
    {
        /** @var Option $option */
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['CHECKOUT_SHIPPING_DETAILS_SUBTITLE']))
            {
                $localization ['CHECKOUT_SHIPPING_DETAILS_SUBTITLE'] = 'Shipping details:';
            }

            if (!isset ($localization ['CHECKOUT_BILLING_DETAILS_SUBTITLE']))
            {
                $localization ['CHECKOUT_BILLING_DETAILS_SUBTITLE'] = 'Billing details:';
            }

            if (!isset ($localization ['CHECKOUT_STEP_2']) || ($localization ['CHECKOUT_STEP_2'] == "STEP 2: Shipping Details") )
            {
                $localization ['CHECKOUT_STEP_2'] = 'STEP 2: Billing/Shipping Details';
            }

            if (!isset ($localization ['CHECKOUT_SHIP_TO_DIFFERENT_ADDRESS']))
            {
                $localization ['CHECKOUT_SHIP_TO_DIFFERENT_ADDRESS'] = 'Ship to different address';
            }

            if (!isset ($localization ['SHOPPING_CART_SHIPPING_METHOD']))
            {
                $localization ['SHOPPING_CART_SHIPPING_METHOD'] = 'Shipping Method';
            }
            if (!isset ($localization ['SHOPPING_CART_SHIPPING_COST']))
            {
                $localization ['SHOPPING_CART_SHIPPING_COST'] = 'Shipping';
            }
            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }

    public function import ()
    {

        $this->addTranslation ();
    }
}