<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;

class Update_137 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
/*
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
*/

    }
    public function addTranslation ()
    {
        /** @var Option $option */
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['PAYMENT_GATEWAY']))
            {
                $localization ['PAYMENT_GATEWAY'] = 'Payment Gateway';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }

    public function import ()
    {

        $this->addTranslation ();
        $this->updateOptions();
    }
    public function updateOptions(){

        $newOptions =   array(
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_paymentgateway_name'),
        );

        foreach ($newOptions as $opt){
            $option = $this->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array(
                    'module_name' => $opt[0],
                    'option_key' => $opt[1]
                ));
            if (!$option){
                $option = new Option ($opt [0], $opt [1], 1);
                $this->entityManager->persist ($option);
            }

        }
        $this->entityManager->flush ();

    }
}