<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_139 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Related'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        if (class_exists('Moto\Website\SitemapService', false)){
            $settings = Moto\Website\SitemapService::getSettings();
            $store_produt = array(
                "type"=> "store.product",
                "priority"=> "0.6",
                "frequency"=>NULL,
                "label" => "STORE.PRODUCT.TITLE",
                "owner" => "plugin:moto-store-plugin"
            );
            $store_category = array(
                "type"=> "store.category",
                "priority"=> "0.6",
                "frequency"=>NULL,
                "label" => "STORE.CATEGORY.TITLE",
                "owner" => "plugin:moto-store-plugin"
            );

            if (!function_exists('array_column')) {

                function array_column($input = null, $columnKey = null, $indexKey = null)
                {
                    $argc = func_num_args();
                    $params = func_get_args();
                    if ($argc < 2) {
                        trigger_error("array_column() expects at least 2 parameters, {$argc} given", E_USER_WARNING);
                        return null;
                    }
                    if (!is_array($params[0])) {
                        trigger_error(
                            'array_column() expects parameter 1 to be array, ' . gettype($params[0]) . ' given',
                            E_USER_WARNING
                        );
                        return null;
                    }
                    if (!is_int($params[1])
                        && !is_float($params[1])
                        && !is_string($params[1])
                        && $params[1] !== null
                        && !(is_object($params[1]) && method_exists($params[1], '__toString'))
                    ) {
                        trigger_error('array_column(): The column key should be either a string or an integer', E_USER_WARNING);
                        return false;
                    }
                    if (isset($params[2])
                        && !is_int($params[2])
                        && !is_float($params[2])
                        && !is_string($params[2])
                        && !(is_object($params[2]) && method_exists($params[2], '__toString'))
                    ) {
                        trigger_error('array_column(): The index key should be either a string or an integer', E_USER_WARNING);
                        return false;
                    }
                    $paramsInput = $params[0];
                    $paramsColumnKey = ($params[1] !== null) ? (string)$params[1] : null;
                    $paramsIndexKey = null;
                    if (isset($params[2])) {
                        if (is_float($params[2]) || is_int($params[2])) {
                            $paramsIndexKey = (int)$params[2];
                        } else {
                            $paramsIndexKey = (string)$params[2];
                        }
                    }
                    $resultArray = array();
                    foreach ($paramsInput as $row) {
                        $key = $value = null;
                        $keySet = $valueSet = false;
                        if ($paramsIndexKey !== null && array_key_exists($paramsIndexKey, $row)) {
                            $keySet = true;
                            $key = (string)$row[$paramsIndexKey];
                        }
                        if ($paramsColumnKey === null) {
                            $valueSet = true;
                            $value = $row;
                        } elseif (is_array($row) && array_key_exists($paramsColumnKey, $row)) {
                            $valueSet = true;
                            $value = $row[$paramsColumnKey];
                        }
                        if ($valueSet) {
                            if ($keySet) {
                                $resultArray[$key] = $value;
                            } else {
                                $resultArray[] = $value;
                            }
                        }
                    }
                    return $resultArray;
                }
            }
            if (!array_search('store.product', array_column($settings['content_preferences'], 'type'))){
                array_push($settings['content_preferences'], $store_produt);
            }
            if (!array_search('store.category', array_column($settings['content_preferences'], 'type'))){
                array_push($settings['content_preferences'], $store_category);
            }
            Moto\Website\SitemapService::saveSettings($settings);
        }

    }

    public function import ()
    {


    }
}