<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_143 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {

                $classes = array (
                    $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Order'),
                );
                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true);

                $classes = array (
                    $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category'),
                );
                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true);

                $classes = array (
                    $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category\Relation'),
                );
                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true);
                $classes = array (
                    $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\CategoryProperty\Relation'),
                );
                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true);

                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true); $classes = array (
                    $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\CategoryBrand\Relation'),
                );
                $this
                    ->getSchemaTool()
                    ->updateSchema ($classes, true);


    }


    public function addTranslation ()
    {


    }

    public function import ()
    {
        $this->addTranslation ();
        $this->updateOptions();
    }


    public function updateOptions(){

        $newOptions =   array(
            array(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_phone'),
        );

        foreach ($newOptions as $opt){
            $option = $this->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array(
                    'module_name' => $opt[0],
                    'option_key' => $opt[1]
                ));
            if (!$option){
                $option = new Option ($opt [0], $opt [1], 1);
                $this->entityManager->persist ($option);
            }

        }
        $this->entityManager->flush ();

    }
}