<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_145 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
    }


    public function addTranslation ()
    {

        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['STORE_IS_CLOSED']))
            {
                $localization ['STORE_IS_CLOSED'] = 'Unfortunately, our store is closed now. Please, return in working hours.';
            }

            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }


    public function import ()
    {
        $this->addTranslation ();

    }


}