<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_147 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Order\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
    }


    public function addTranslation ()
    {

    }

    public function import ()
    {
        $this->addTranslation ();
        $this->updateOptions();
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_147.sql');
    }
    public function updateOptions(){

        $newOptions =   array(
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_order_id'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_payment_name'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_city'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_state'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_country'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_address'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_name'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_email'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_zip'),
            array(Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_phone')
        );

        foreach ($newOptions as $opt){
            $option = $this->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array(
                    'module_name' => $opt[0],
                    'option_key' => $opt[1]
                ));
            if (!$option){
                $option = new Option ($opt [0], $opt [1], 1);
                $this->entityManager->persist ($option);
            }

        }
        $this->entityManager->flush ();

    }
}