<?php


namespace MotoStore\Update\Version;

use MotoStore\Settings\Entity\Option;
use MotoStore\Update\Schema\AbstractSchema;
use Moto;

class Update_148 extends AbstractSchema
{
    /**
     * Up process
     *
     * @return mixed
     */
    public function update ()
    {
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\CustomOption'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Product'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);
        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ('\MotoStore\Product\Entity\Category\Relation'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Product\Entity\Category\Locale'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);

        $classes = array (
            $this->entityManager->getClassMetadata ( 'MotoStore\Mailer\Entity\Template'),
        );
        $this
            ->getSchemaTool()
            ->updateSchema ($classes, true);



    }

    public function addSettings ()
    {

        $settings = Moto\Website\SitemapService::getSettings();
        $store_mainpage= array(
            "type" => "store.mainpage",
            "priority" => "0.8",
            "frequency" => NULL,
            "label" => "STORE.SETTINGS.MAIN_PAGE_TITLE",
            "owner" => "plugin:moto-store-plugin"
        );

        if (!array_search('store.mainpage', array_column($settings['content_preferences'], 'type'))) {
            array_push($settings['content_preferences'], $store_mainpage);
        }
        Moto\Website\SitemapService::saveSettings($settings);


    }


    public function addTranslation ()
    {
        $option = $this->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array(
                'module_name' => 'storesettings_system',
                'option_key' => 'localization'
            ));

        if ($option)
        {

            $this->entityManager->refresh ($option);
            $localization = json_decode ($option->getOptionValue (), true);

            if (!isset ($localization ['ORDER_ID']))
            {
                $localization ['ORDER_ID'] = 'Order #';
            }


            $option->setOptionValue(json_encode ($localization));

            $this->entityManager->merge ($option);
            $this->entityManager->flush ();


        }

    }
    public function import ()
    {
        $this->addTranslation();
        $this->addSettings ();
        $this->sample (MOTOSTORE_ROOT_DIR . '/var/samples/sample_148.sql');
    }

}