﻿CKEDITOR.plugins.add('motobootstraptable', {
    requires: 'dialog,table',
    icons: 'table', // %REMOVE_LINE_CORE%
    lang: 'en,ru,de',
    hidpi: true, // %REMOVE_LINE_CORE%
    init: function(editor) {
        var lang;

        if (editor.blockless)
        return;

        lang = editor.lang.table;

        editor.addCommand('motobootstraptable', new CKEDITOR.dialogCommand('motobootstraptable', {
            context: 'table',
            allowedContent: 'table{width,height}[align,border,cellpadding,cellspacing,summary];' +
            'caption tbody thead tfoot;' +
            'th td tr[scope];' +
            (editor.plugins.dialogadvtab ? 'table' + editor.plugins.dialogadvtab.allowedContent() : ''),
            requiredContent: 'table',
            contentTransformations: [
                [ 'table{width}: sizeToStyle', 'table[width]: sizeToAttribute' ]
            ]
        }));

        function createDef(def) {
            return CKEDITOR.tools.extend(def || {}, {
                contextSensitive: 1,
                refresh: function(editor, path) {
                    this.setState(path.contains('table', 1) ? CKEDITOR.TRISTATE_OFF : CKEDITOR.TRISTATE_DISABLED);
                }
            });
        }

        editor.addCommand('motobootstraptableProperties', new CKEDITOR.dialogCommand('motobootstraptableProperties', createDef()));

        editor.ui.addButton && editor.ui.addButton('Table', {
            label: lang.toolbar,
            command: 'motobootstraptable',
            toolbar: 'motocontentplugins,30'
        });

        CKEDITOR.dialog.add('motobootstraptable', this.path + 'dialogs/table.js');
        CKEDITOR.dialog.add('motobootstraptableProperties', this.path + 'dialogs/table.js');

        // If the "menu" plugin is loaded, register the menu items.
        if (editor.addMenuItems) {
            editor.addMenuItems({
                table: {
                    label: lang.menu,
                    command: 'motobootstraptableProperties',
                    group: 'table',
                    order: 5
                },
            });
        }

        editor.on('doubleclick', function(evt) {
            var element = evt.data.element;

            if (element.is('table'))
            evt.data.dialog = 'motobootstraptableProperties';
        });

        // If the "contextmenu" plugin is loaded, register the listeners.
        if (editor.contextMenu) {
            editor.contextMenu.addListener(function() {
                // menu item state is resolved on commands.
                return {
                    motobootstraptable: CKEDITOR.TRISTATE_OFF
                };
            });
        }
    }
});
