<?php
 namespace Moto\Application\Blocks; use Moto; use JsonSerializable; use Illuminate\Contracts\Support\Jsonable; use Illuminate\Contracts\Support\Arrayable; class BlockCategory implements JsonSerializable, Jsonable, Arrayable { protected $_attributes = array( 'id' => null, 'provider' => null, 'name' => null, 'label' => null, 'order' => 250, ); protected $_collection; protected $_template; protected $_content; protected $_modified = array(); public function __construct($data, $collection) { if (is_array($data)) { $this->fromArray($data); } $this->setCollection($collection); $this->_updateData(); } public function fromArray($data) { $data = (array) $data; foreach ($data as $name => $value) { $this->__set($name, $value); } return $this; } public function setCollection($collection) { $this->_collection = $collection; return $this; } protected function _updateData() { if (!$this->id) { $this->id = $this->_collection->generateItemId($this); } if (!$this->created_at) { $this->updated_at = time(); $this->created_at = $this->updated_at; } } public function isEmptyOption($name) { return (array_key_exists($name, $this->_attributes['options']) ? empty($this->_attributes['options'][$name]) : true); } public function setOption($name, $value) { $this->_attributes['options'][$name] = $value; return $this; } public function toArray() { return $this->_attributes; } public function __get($name) { $method = 'get' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}(); } return (array_key_exists($name, $this->_attributes) ? $this->_attributes[$name] : null); } public function __set($name, $value) { $method = 'set' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } else { $this->_attributes[$name] = $value; } } public function __isset($name) { return array_key_exists($name, $this->_attributes); } public function getOption($name, $default = null) { return (array_key_exists($name, $this->_attributes['options']) ? $this->_attributes['options'][$name] : $default); } public function isDraft() { return (empty($this->id)); } public function delete() { $this->deleted_at = time(); } public function save() { if ($this->trashed()) { return; } if (!$this->isModified()) { return; } $this->_updateData(); $this->updated_at = time(); } public function trashed() { return (array_key_exists('deleted_at', $this->_attributes)); } public function isModified($name = null) { if (empty($name)) { return !!count($this->_modified); } else { return array_key_exists($name, $this->_modified); } } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { return json_encode($this->jsonSerialize(), $options); } } 