<?php
 namespace Moto\Application\Blocks; use Illuminate\Support\Collection; use Moto; use JsonSerializable; use Illuminate\Contracts\Support\Jsonable; use Illuminate\Contracts\Support\Arrayable; class BlockTemplateCollection implements JsonSerializable, Jsonable, Arrayable { protected $_categories; protected $_items; protected $_loaded = false; protected $_options = array( 'provider' => 'theme', 'blocksDataFile' => '@currentTheme/data/blocks/blocks.json', 'basePath' => '@currentTheme/data/blocks', 'idPrefix' => '', 'BlockItemClass' => BlockItem::class, 'BlockCategoryClass' => BlockCategory::class, ); public function __construct($options = []) { $this->setOptions($options); if (!$this->isEmptyOption('blocksDataFile')) { $this->loadBlockList(); } } public function setOption($name, $value) { $this->_options[$name] = $value; return $this; } public function setOptions($options) { if (!is_array($options)) { return false; } foreach ($options as $name => $value) { $this->setOption($name, $value); } return true; } public function isEmptyOption($name) { return (array_key_exists($name, $this->_options) ? empty($this->_options[$name]) : true); } public function loadBlockList() { if ($this->_loaded) { return false; } $filePath = $this->getOption('blocksDataFile'); $filePath = Moto\System::getAbsolutePath($filePath); if (!file_exists($filePath)) { return false; } $data = file_get_contents($filePath); $data = json_decode($data, true); $itemsCollection = $this->getItems(); $items = Moto\Util::getFrom($data, 'items', array()); foreach ($items as $item) { $item = $this->_createItem($item); if (!$item) { continue; } $itemsCollection->push($item); } $categoriesCollection = $this->getCategories(); $categories = Moto\Util::getFrom($data, 'categories', array()); foreach ($categories as $item) { $item = $this->_createCategory($item); if (!$item) { continue; } $categoriesCollection->push($item); } $this->_loaded = true; return true; } public function getOption($name, $default = null) { return (array_key_exists($name, $this->_options) ? $this->_options[$name] : $default); } protected function _createItem($data) { $class = $this->getOption('BlockItemClass'); $data['provider'] = $this->getOption('provider'); $item = new $class($data, $this); if (!$item->id) { return false; } if ($this->getItemById($item->id)) { return false; } return $item; } protected function _createCategory($data) { $class = $this->getOption('BlockCategoryClass'); $data['provider'] = $this->getOption('provider'); $item = new $class($data, $this); if (!$item->id) { return false; } if ($this->getItemById($item->id)) { return false; } return $item; } public function getItems() { if (!$this->_items) { $this->_items = new Collection(); } return $this->_items; } public function getCategories() { if (!$this->_categories) { $this->_categories = new Collection(); } return $this->_categories; } public function getItemById($id) { return $this->getItems()->firstWhere('id', $id); } public function getCategoryById($id) { return $this->getCategories()->firstWhere('id', $id); } public function getCategoryByName($name) { return $this->getCategories()->firstWhere('name', $name); } public function addItem($item) { if ($item instanceof BlockItem) { if ($this->getItemById($item->id)) { return false; } $item->setCollection($this); } else { $item = $this->createItem($item); } $collection = $this->getItems(); $collection->push($item); return $item; } public function createItem($data = array()) { if (is_array($data)) { } $class = $this->getOption('BlockItemClass'); $data['provider'] = $this->getOption('provider'); return new $class($data, $this); } public function addCategory($item) { if ($item instanceof BlockCategory) { if ($this->getCategoryById($item->id)) { return false; } $item->setCollection($this); } else { $item = $this->createCategory($item); } $collection = $this->getCategories(); $collection->push($item); return $item; } public function createCategory($data = array()) { if (is_array($data)) { $data['id'] = null; } $class = $this->getOption('BlockCategoryClass'); $data['provider'] = $this->getOption('provider'); return new $class($data, $this); } public function save() { foreach ($this->getItems() as $item) { $item->save(); } if (!defined('JSON_PRETTY_PRINT')) { define('JSON_PRETTY_PRINT', 128); } $filePath = $this->getOption('blocksDataFile'); $filePath = Moto\System::getAbsolutePath($filePath); Moto\Util::filePutContents($filePath, json_encode($this->toArray(), JSON_PRETTY_PRINT), LOCK_EX); Moto\Util::disableDirectoryWebIndexing(dirname($filePath)); } public function toArray() { $data = array( 'categories' => array(), 'items' => array(), ); foreach ($this->getItems() as $item) { if ($item->isDraft() || $item->trashed()) { continue; } $data['items'][] = $item->toArray(); } foreach ($this->getCategories() as $item) { if ($item->isDraft() || $item->trashed()) { continue; } $data['categories'][] = $item->toArray(); } return $data; } public function generateItemId($item = null) { $id = $this->getOption('idPrefix'); if (!empty($id)) { $id .= '-'; } $id .= Moto\Util::getUniqueId(); return $id; } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { return json_encode($this->jsonSerialize(), $options); } } 