<?php
 namespace Moto\Application\Blocks\InputFilter; use Moto\InputFilter\AbstractInputFilter; use Moto; class SaveBlockTemplate extends AbstractInputFilter { protected $_name = 'blockTemplate.save'; public function init() { $this->add(array( 'name' => 'id', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), ), )); $this->add(array( 'name' => 'name', 'required' => false, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('block') ) ) ), )); $this->add([ 'name' => 'provider', 'required' => true, 'filters' => [ ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'InArray', 'options' => [ 'haystack' => ['theme', 'website',], ], ], ], ]); $this->add(array( 'name' => 'previewUrl', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), ), )); $this->add([ 'name' => 'previewContent', 'required' => false, 'validators' => [ [ 'name' => 'Callback', 'options' => [ 'callback' => function ($value) { return is_string($value) && preg_match('/^data:image\/(jpeg);base64,/', substr($value, 0, 32), $match); }, ], ], ], ]); $this->add(array( 'name' => 'category', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), ), )); $this->add(array( 'name' => 'order', 'required' => false, 'allow_empty' => true, )); $this->add(array( 'name' => 'allowed', 'required' => false, 'allow_empty' => true, )); $this->add(array( 'name' => 'options', 'required' => false, 'allow_empty' => true, )); $this->add(array( 'name' => 'content', 'required' => false, 'allow_empty' => true, )); } public function getValues($keys = null, $ignoreDefault = false) { $values = parent::getValues($keys, $ignoreDefault); if (empty($values['template'])) { unset($values['template']); } return $values; } } 