<?php
 namespace Moto\Application\Cache; use Moto; use Illuminate; class BackendService extends Moto\Service\AbstractService { const GLOBAL_SETTING_NAMESPACE = 'cache_settings'; const SETTING_NAMESPACE = null; protected $_resourceName = 'cache'; public function getDefaultSettings() { return [ 'enabled' => false, ]; } protected function getGlobalSettings() { $settings = Moto\Website\Settings::get(static::GLOBAL_SETTING_NAMESPACE); if ($settings === null) { $settings = []; } if (is_string($settings)) { $settings = json_decode($settings, true); } if (!is_array($settings)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::error('Invalid global cache settings'); throw new Moto\Exception('Invalid global cache settings'); } } return $settings; } protected function getNamespace() { $namespace = static::SETTING_NAMESPACE; if (!is_string($namespace)) { throw new Moto\Exception('[' . get_class($this) . '] : SETTING_NAMESPACE not a string'); } $namespace = trim($namespace); if ($namespace === '') { throw new Moto\Exception('[' . get_class($this) . '] : Invalid SETTING_NAMESPACE value'); } return $namespace; } public function getSettings() { $namespace = $this->getNamespace(); $global = $this->getGlobalSettings(); $settings = Moto\Util::getValue($global, $namespace); if (!is_array($settings)) { $settings = $this->getDefaultSettings(); } return (array) $settings; } protected function updateSettings(array $value) { Moto\Website\Settings::loadData(true); $namespace = $this->getNamespace(); $global = $this->getGlobalSettings(); $global[$namespace] = array_merge($this->getSettings(), $value); if (Moto\Website\Settings::isExists(static::GLOBAL_SETTING_NAMESPACE)) { Moto\Website\Settings::set(static::GLOBAL_SETTING_NAMESPACE, $global); } else { Moto\Website\Settings::add(static::GLOBAL_SETTING_NAMESPACE, $global, 'array'); } return $global[$namespace]; } public function setSettings($request = null) { throw new Moto\Exception('Method not implemented'); } } 