<?php
 namespace Moto\Application\Content\InputFilter; use Moto; class TaxonomyStoreRequest extends Moto\InputFilter\AbstractInputFilter { protected $_name = 'content.taxonomy.store'; protected $_defaultsValue = []; public function init() { $model = $this->getOption('model'); $this->add(array( 'name' => 'name', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), array( 'name' => Moto\Application\Content\Validator\UniqueTaxonomy::class, 'options' => array( 'model' => $model, 'field' => 'name', ) ), ), )); $this->add(array( 'name' => 'slug', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array('name' => 'StringToLower'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 200, ), ), array( 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => array( 'pattern' => '/^([a-z0-9\_\-]{1,200})$/', ) ), array( 'name' => Moto\Application\Content\Validator\UniqueTaxonomy::class, 'options' => array( 'model' => $model, 'field' => 'slug', ) ), ), )); $this->add(array( 'name' => 'short_description', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\StripCode'), array('name' => 'Moto\Filter\BodyContent'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 0, 'max' => 16000, ), ), ), )); $this->add(array( 'name' => 'long_description', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'Moto\Filter\StripCode'), array('name' => 'Moto\Filter\BodyContent'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 0, 'max' => 64000, ), ), ), )); if (empty($model->type)) { $this->add(array( 'name' => 'type', 'required' => false, 'allow_empty' => false, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 3, 'max' => 48, ), ), array( 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => array( 'pattern' => '/^[\@]?([a-z0-9\_\-\.\:]{3,48})$/', ) ), ), )); } else { $this->add(array( 'name' => 'type', 'required' => false, 'allow_empty' => false, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array($model->type) ) ), ), )); } $this->add(array( 'name' => 'attraction_level', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Between', 'options' => array( 'min' => 0, 'max' => 65535, ), ), ), )); $this->add(array( 'name' => 'parent_id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Moto\Validator\Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'content_taxonomies', 'field' => 'id', 'allow_zero' => true, 'allow_null' => true, ) ) ), )); $this->add(array( 'name' => 'group_id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Moto\Validator\Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'content_taxonomies', 'field' => 'id', 'allow_zero' => true, 'allow_null' => true, ) ) ), )); $this->add(new TaxonomyProperties(), 'properties'); } } 