<?php
namespace Moto\Application\Content\Table; use Moto\Application\Content\Model\ContentBlock; use Moto\Application\Model\AbstractTable; use Zend\Db\ResultSet\ResultSet; use Zend\Db\Sql\Select; use Zend\Db\Sql\Where; use Moto; class ContentBlocks extends AbstractTable { protected $table = 'content_blocks'; protected $_resultModel = 'Moto\Application\Content\Model\ContentBlock'; protected $_primaryKey = 'id'; public function getList($request = null) { $select = new Select($this->table); $select->columns(array( 'count' => new \Zend\Db\Sql\Expression("COUNT(*)") )); $result = $this->executeSelect($select); $total = $result->current()->count; $select->columns(array('id', 'name', 'type', 'is_system', 'properties', 'styles', 'modified', 'created')); $select->order(array('id' => 'ASC')); $records = $this->executeSelect($select); $result = array( 'meta' => array( 'total' => $total, 'limit' => 0, 'page' => 0, ), 'records' => $records->toArray() ); return $result; } public function getBody() { $select = new Select($this->table); $select->where(array( 'type' => 'body' )); $resultSet = $this->executeSelect($select); return $resultSet->current(); } public function getById($id) { $row = is_numeric($id); if ($row) { $select = new Select($this->table); $select->where(array( 'id' => $id )); $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function getCustomContenBlockById($id) { $row = is_numeric($id); if ($row) { $select = new Select($this->table); $where = new Where(); $where->equalTo('id', $id); $where->equalTo('is_system', 0); $where->notEqualTo('type', 'body'); $select->where($where); $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function getDefaultContentBlock($type = 'body') { $select = new Select($this->table); $where = new Where(); $where->equalTo('is_system', 1); $where->equalTo('type', $type); $select->where($where); $resultSet = $this->executeSelect($select); return $resultSet->current(); } public function deleteContentBlock($contentBlock) { if (is_array($contentBlock)) { $contentBlock = (object) $contentBlock; } if (!is_object($contentBlock)) { throw new \InvalidArgumentException('Block is not object'); } $containers = array(); if (!empty($contentBlock->content)) { $containers = Moto\Application\Content\Util::findContainers(trim($contentBlock->content)); } $where = new Where(); $where->equalTo($this->_primaryKey, $contentBlock->id); $where->equalTo('is_system', 0); $where->notEqualTo('type', 'body'); $res = $this->delete($where); if ($res) { $defaultContentBlock = $this->getDefaultContentBlock($contentBlock->type); } if (!empty($containers)) { $table = new Moto\Application\Styles\StylesTable(); $table->deleteByClassName($containers); } return $res; } public function createDuplicate(ContentBlock $item) { $newItem = $item->duplicate(); $styles = array(); $containers = Moto\Application\Content\Util::findContainers($newItem->content); if (!empty($containers)) { $styleTable = new Moto\Application\Styles\StylesTable(); $styleTable->useResultAsModel(true); foreach ($containers as $containerClassName) { $newClassName = 'moto-container_' . $newItem->type . '_' . Moto\Util::getUniqueId(); $style = $styleTable->getByClassName($containerClassName); if ($style) { $newStyle = $styleTable->duplicate($style); $newStyle->name = $newStyle->class_name = $newClassName; $styles[] = $newStyle; } $newItem->content = str_replace($containerClassName, $newClassName, $newItem->content); } } $this->insert($newItem); if (!empty($styles)) { foreach($styles as $style) { $styleTable->save($style); } Moto\System\Style::rebuildAll(); } return $newItem; } public function update($model, $where = null) { $removedContainers = array(); if ($model instanceof $this->_resultModel && $model->isModified('content') && !empty($model->content) && is_string($model->content)) { $originalContainers = Moto\Application\Content\Util::findContainers(trim($model->getOriginal('content', ''))); $currentContainers = Moto\Application\Content\Util::findContainers(trim($model->content)); $removedContainers = array_diff($originalContainers, $currentContainers); } $result = parent::update($model, $where); if (!empty($removedContainers)) { $table = new Moto\Application\Styles\StylesTable(); $table->deleteByClassName($removedContainers); } return $result; } } 