<?php
namespace Moto\Application\Content; use Moto; use Illuminate; class TaxonomyProvider { const INITIATOR__INSTALLER = '@INSTALL'; const INITIATOR__UPDATER = '@UPDATE'; protected static $_tables = [ 'content_taxonomies', 'content_taxonomy_relations', ]; protected static $_initiator; public static function install() { try { static::$_initiator = static::INITIATOR__INSTALLER; static::createAllTables(); static::$_initiator = null; } catch (\Exception $e) { static::error('Tags Exception: [ ' . $e->getCode() . ' ] ' . $e->getMessage()); return false; } static::$_initiator = null; return true; } public static function update($fromBuild = 0) { try { static::$_initiator = static::INITIATOR__UPDATER; static::createAllTables(); static::$_initiator = null; } catch (\Exception $e) { static::error('Tags Exception: [ ' . $e->getCode() . ' ] ' . $e->getMessage()); return false; } static::$_initiator = null; return true; } public static function getTables() { return static::$_tables; } public static function getNotExistsTables() { $result = []; foreach (static::$_tables as $tableName) { if (!static::isTableExists($tableName)) { $result[] = $tableName; } } return $result; } public static function isTableExists($name) { return static::_getSchemaBuilder()->hasTable($name); } public static function createAllTables() { foreach (static::$_tables as $tableName) { if (!static::createTable($tableName)) { return false; } } return true; } public static function createTable($name) { switch ($name) { case 'content_taxonomies': return static::createContentTaxonomiesTable(); case 'content_taxonomy_relations': return static::createContentTaxonomyRelationsTable(); } throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } protected static function createContentTaxonomiesTable() { $schemaBuilder = static::_getSchemaBuilder(); $tableName = 'content_taxonomies'; if ($schemaBuilder->hasTable($tableName)) { static::info('Table `content_taxonomies` already exists'); } else { static::info('Creating table `content_taxonomies`'); $schemaBuilder->create($tableName, function ($table) use ($schemaBuilder) { $connection = $schemaBuilder->getConnection(); $table->increments('id'); $table->string('name')->default(''); $table->string('slug')->default(''); $table->string('type', 48)->default(''); $table->unsignedInteger('assigned_count')->default(0); $table->smallInteger('attraction_level', false, true)->default(0); $table->unsignedInteger('parent_id')->default(0); $table->unsignedInteger('group_id')->default(0); $table->text('short_description')->nullable(); $table->text('long_description')->nullable(); $table->text('properties')->nullable(); $table->timestamp('created_at')->nullable(); $table->timestamp('updated_at')->nullable(); $table->unique([$connection->raw('`slug` (191) , `type`, `parent_id`')], 'slug__type__parent'); $table->index([$connection->raw('`type`, `name` (191)')], 'type__name'); $table->index(['group_id', 'type'], 'group__type'); }); static::info('Table was created'); } return true; } protected static function createContentTaxonomyRelationsTable() { $schemaBuilder = static::_getSchemaBuilder(); $tableName = 'content_taxonomy_relations'; if ($schemaBuilder->hasTable($tableName)) { static::info('Table `content_taxonomy_relations` already exists'); } else { static::info('Creating table `content_taxonomy_relations`'); $schemaBuilder->create($tableName, function ($table) { $table->unsignedInteger('taxonomy_id'); $table->unsignedInteger('target_id'); $table->integer('order_position')->default(0); $table->primary(['taxonomy_id', 'target_id'], 'taxonomy__target'); $table->index(['target_id', 'order_position'], 'target__position'); }); static::info('Table was created'); } return true; } protected static function _getSchemaBuilder() { return Moto\Database\Provider::getSchemaBuilder(); } protected static function info($message, $context = array()) { Moto\System\Log::info((string) static::$_initiator . ' : ' . $message, $context); } protected static function error($message, $context = array()) { Moto\System\Log::error((string) static::$_initiator . ' : ' . $message, $context); } } 