<?php
 namespace Moto\Application\ContentSection; use Moto; use Moto\Json\Server; use Zend; class Service extends Moto\Service\AbstractService { protected $_resourceName = 'contentSection'; protected $_resourcePrivilegesMap = array( 'getSettings' => 'get', 'getMainPage' => 'get', 'getPosts' => 'get', 'getTemplates' => 'get', 'getTemplate' => 'get', 'getDefinition' => 'get', 'setSettings' => 'set', 'storeTaxonomy' => 'set', 'updateTaxonomy' => 'set', 'destroyTaxonomy' => 'set', ); protected function getManager() { return Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); } protected function getProvider($name) { return $this->getManager()->getProvider($name); } protected function requireProvider($name) { $provider = $this->getProvider($name); if ($provider) { return $provider; } throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, array('section' => array('notExists'))); } public function getSettings($section) { return $this->requireProvider($section) ->getProperties(); } public function setSettings($section, $value) { $provider = $this->requireProvider($section); $filter = $provider->getSettingInputFilter(); $filter->setData($value); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); $provider->setProperties($values); $provider->saveConfiguration(); return $provider->getProperties(); } public function getMainPage($section) { return $this->requireProvider($section) ->getMainPage(); } public function getPosts($section) { $provider = $this->requireProvider($section); $query = $provider->getPostQuery(); $query->with([ 'tags' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); $query->orderBy('name'); }, 'category' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type',]); }, 'taxonomies' => function ($query) { $query->addSelect(['id', 'name', 'slug', 'type', 'created_at',]); }, ]); $items = $query->get(array( 'id', 'name', 'url', 'title', 'author_id', 'parent_id', 'category_id', 'is_system', 'type', 'status', 'visibility', 'properties', 'layout', 'styles', 'published', 'background_id', 'short_description', 'modified', 'created', )); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 0, )); $response->records = $items->toArray(); return $response; } public function getTemplates($section) { return $this->requireProvider($section) ->getTemplates()->toArray(); } public function getTemplate($section, $template) { return $this->requireProvider($section) ->getTemplate($template); } public function getDefinition($section) { return [ 'index' => $this->getMainPage($section), 'templates' => $this->getTemplates($section), 'settings' => $this->getSettings($section), ]; } public function storeTaxonomy($section, $definition) { $provider = $this->requireProvider($section); $filter = new InputFilter\StoreTaxonomyDefinition([ 'provider' => $provider, ]); $filter->setData($definition); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(true); try { $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); $taxonomy = $provider->createTaxonomyDefinition($values); if (!$taxonomy) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, [ 'errors' => [ 'common' => 'cantCreateTaxonomy' ], ]); } $connection->commit(); return $taxonomy; } catch (\Exception $e) { $connection->rollBack(); throw $e; } } public function updateTaxonomy($section, $definition) { $provider = $this->requireProvider($section); $filter = new InputFilter\UpdateTaxonomyDefinition([ 'provider' => $provider, ]); $filter->setData($definition); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } try { $values = $filter->getValues(true); $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); $taxonomy = $provider->updateTaxonomyDefinition($values['name'], $values); $connection->commit(); return $taxonomy; } catch (\Exception $e) { $connection->rollBack(); throw $e; } } public function destroyTaxonomy($section, $name) { $provider = $this->requireProvider($section); $filter = new InputFilter\DestroyTaxonomyDefinition([ 'provider' => $provider, ]); $filter->setData([ 'name' => $name, ]); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } try { $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); $result = $provider->deleteTaxonomyDefinition($filter->getValue('name')); $connection->commit(); return $result; } catch (\Exception $e) { $connection->rollBack(); throw $e; } } } 