<?php
namespace Moto\Application\Extra; use Moto; use Zend; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'extra'; protected static $_resourcePrivilegesMap = array( 'getUrlHeaders' => 'get', 'getUrlFrameOptions' => 'get', 'retrieveUrlContent' => 'get', ); public static function getUrlHeaders($url = null) { if (null === $url) $url = static::getRequest()->getParam('url'); $filter = new InputFilter\Iframe(); $filter->setData(array( 'url' => $url )); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $options = array( 'maxredirects' => 1, 'curloptions' => array( CURLOPT_HEADER => 1, CURLOPT_FOLLOWLOCATION => false, CURLOPT_CONNECTTIMEOUT => 15, CURLOPT_TIMEOUT => 25 ), ); $info = parse_url($url); if (isset($info['scheme'])) { $info['scheme'] = strtolower($info['scheme']); if ($info['scheme'] == 'https') { if (!isset($options['curloptions'][CURLOPT_SSL_VERIFYPEER])) $options['curloptions'][CURLOPT_SSL_VERIFYPEER] = false; if (!isset($options['curloptions'][CURLOPT_SSL_VERIFYHOST])) $options['curloptions'][CURLOPT_SSL_VERIFYHOST] = 0; } } $client = new Moto\Http\Client($url, $options); $client->send(); $response = $client->getResponse(); $headers = $response->getHeaders(); if ($headers->count() == 0) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } return $headers->toArray(); } public static function getUrlFrameOptions($url = null) { $headers = static::getUrlHeaders($url); return (array_key_exists('X-Frame-Options', $headers) ? $headers['X-Frame-Options'] : null); } public static function retrieveUrlContent() { $request = static::getRequest(); $url = $request->getParam('url'); $filter = new InputFilter\Content(); $filter->setData(array( 'url' => $url )); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $options = array( 'maxredirects' => 5, 'curloptions' => array( CURLOPT_HEADER => 1, CURLOPT_FOLLOWLOCATION => false, ), ); $info = parse_url($url); if (isset($info['scheme'])) { $info['scheme'] = strtolower($info['scheme']); if ($info['scheme'] === 'https') { if (!isset($options['curloptions'][CURLOPT_SSL_VERIFYPEER])) { $options['curloptions'][CURLOPT_SSL_VERIFYPEER] = false; } if (!isset($options['curloptions'][CURLOPT_SSL_VERIFYHOST])) { $options['curloptions'][CURLOPT_SSL_VERIFYHOST] = 0; } } } $client = new Moto\Http\Client($url, $options); $client->send(); $adapter = $client->getAdapter(); $info = null; $result = []; $httpError = []; if ($adapter instanceof Zend\Http\Client\Adapter\Curl) { $handle = $adapter->getHandle(); $httpError['code'] = curl_errno($handle); $httpError['message'] = curl_error($handle); $httpError['name'] = Moto\Http\Client::getCurlErrorName($httpError['code']); } $response = $client->getResponse(); if ((int) Moto\Util::getValue($httpError, 'code') > 0) { $result['error'] = $httpError; } $result['code'] = $response->getStatusCode(); $result['headers'] = (object) $response->getHeaders()->toArray(); $result['body'] = $response->getBody(); $adapter->close(); return $result; } } 