<?php
namespace Moto\Application\FileManager\Validator; use Moto\Validator\AbstractValidator; class PathExists extends AbstractValidator { const PATH_NOT_EXISTS = 'notExists'; const NOT_VALID = 'notValid'; const NOT_FILE = 'notFile'; protected $messageTemplates = array( self::PATH_NOT_EXISTS => 'Path not exists', self::NOT_VALID => 'Path is not valid', self::NOT_FILE => 'Path is not file', ); protected $options = array( 'checkParentDir' => false, 'checkIfFile' => false, ); public function isValid($path, array $context = array()) { $this->setValue($path); if (!is_string($path)) { $this->error(self::NOT_VALID); return false; } if ($this->getCheckParentDir()) { $path = dirname($path); } if (!file_exists($path) || !is_readable($path)) { $this->error(self::PATH_NOT_EXISTS); return false; } if (!$this->getCheckParentDir() && $this->getCheckIfFile() && !is_file($path)) { $this->error(self::NOT_FILE); return false; } return true; } public function getCheckParentDir() { return (bool)$this->options['checkParentDir']; } public function getCheckIfFile() { return (bool)$this->options['checkIfFile']; } } 