<?php
namespace Moto\Application\Fonts\InputFilter; use Moto; use Moto\InputFilter\AbstractInputFilter; class AddFont extends AbstractInputFilter { protected $_name = 'fonts.new'; public function init() { $this->add(array( 'name' => 'name', 'required' => true, 'break_on_failure' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 32, ), ), array( 'name' => 'Db\NoRecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'fonts', 'field' => 'name', 'adapter' => Moto\System::getDatabaseAdapter(), ) ), ), )); $this->add(array( 'name' => 'family', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 100, ), ) ), )); $this->add(array( 'name' => 'category', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 14, ), ) ), )); $this->add(array( 'name' => 'variants', 'type' => 'Zend\InputFilter\ArrayInput', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('100', '100italic', '200', '200italic', '300', '300italic', '400', '400italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', 'bold', '700italic', '800', '800italic', '900', '900italic',), ) ), ), )); $this->add(array( 'name' => 'subsets', 'type' => 'Zend\InputFilter\ArrayInput', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Regex', 'options' => array( 'pattern' => '/^[a-z]{1,}[a-z0-9\_\-]*$/', ) ), ), )); $this->add(array( 'name' => 'version', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 10, ), ) ), )); $this->add(array( 'name' => 'last_modified', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 10, ), ) ), )); $this->add(array( 'name' => 'active_variants', 'type' => 'Zend\InputFilter\ArrayInput', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('100', '100italic', '200', '200italic', '300', '300italic', '400', '400italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', 'bold', '700italic', '800', '800italic', '900', '900italic',), ) ), array( 'name' => 'Callback', 'options' => array( 'callback' => function ($value, $context) { $variants = Moto\Util::getValue($context, 'variants'); return (is_array($variants) && in_array($value, $variants)); }, ) ), ), )); $this->add(array( 'name' => 'active_subsets', 'type' => 'Zend\InputFilter\ArrayInput', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Regex', 'options' => array( 'pattern' => '/^[a-z]{1,}[a-z0-9\_\-]*$/', ) ), array( 'name' => 'Callback', 'options' => array( 'callback' => function ($value, $context) { $subsets = Moto\Util::getValue($context, 'subsets'); return (is_array($subsets) && in_array($value, $subsets)); }, ) ), ), )); $this->add(array( 'name' => 'provider', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'InArray', 'options' => array( 'haystack' => array('google') ) ), ), )); } } 