<?php
namespace Moto\Application\FontsManager; use Moto\Json\Server; use Moto; class FontsManagerApi { protected $_options = array( 'apiUrl' => 'http://fonts-service.moto3dev.cms-guide.com/api', 'webFontsListFile' => '@webFontsListFile', 'cache' => array( 'ttl' => 900, ), 'curlOptions' => array( CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0, CURLOPT_HEADER => 0, CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => false, CURLOPT_RETURNTRANSFER => true, CURLOPT_CONNECTTIMEOUT => 5, CURLOPT_TIMEOUT => 10, ), ); public function __construct() { $this->_init(); } public function _init() { $this->setOptions(Moto\Config::get('externalModules.webFonts')); } public function setOptions($options) { if (is_array($options)) { foreach ($options as $name => $value) { $this->setOption($name, $value); } } return $this; } public function setOption($name, $value) { $this->_options[$name] = $value; return $this; } public function getOption($name, $default = null) { return Moto\Util::getValue($this->_options, $name, $default); } public function getList() { $webFontsListFile = Moto\System::getAbsolutePath($this->getOption('webFontsListFile')); $needDownload = true; $response = null; if (file_exists($webFontsListFile)) { $delta = abs(time() - filemtime($webFontsListFile)); if ($delta < $this->getOption('cache.ttl')) { $needDownload = false; } } if ($needDownload) { $response = $this->_makeGetApiRequest('/fonts'); if ($response) { Moto\Util::filePutContents($webFontsListFile, json_encode($response)); } } if (!$response && file_exists($webFontsListFile)) { $data = file_get_contents($webFontsListFile); $response = json_decode($data); } return Moto\Util::getValue($response, 'result'); } protected function _makeGetApiRequest($uri) { $response = $this->_makeHTTPRequest($uri); if (!$response || ($response->getStatusCode() !== 200)) { return null; } $content = $response->getBody(); $content = trim($content); $data = json_decode($content); return $data; } protected function _makeHTTPRequest($url, $params = array()) { $method = Moto\Util::getValue($params, 'method', 'GET'); $method = strtoupper($method); $fullUrl = $this->getOption('apiUrl') . '/' . ltrim($url, '/'); $client = $this->_createHttpClient($fullUrl); $client->setMethod($method); $client->send(); $client->getAdapter()->close(); $response = $client->getResponse(); if ($client->hasErrors()) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('FontsManagerApi:' . __FUNCTION__ . ': HTTP error', array('url' => $fullUrl, 'errors' => $client->getErrors())); } else { Moto\System\Log::warning('FontsManagerApi: HTTP error', array('url' => $url, 'errors' => $client->getErrors())); } return null; } return $response; } protected function _createHttpClient($url) { $options = array( 'useragent' => Moto\Util::getValue($_SERVER, 'HTTP_USER_AGENT'), 'maxredirects' => 1, 'curloptions' => $this->getOption('curlOptions'), ); $client = new Moto\Http\Client($url, $options); $this->_updateHttpClient($client); return $client; } protected function _updateHttpClient($client) { if (!$client) { return false; } try { $headers = $client->getRequest()->getHeaders(); $headers->addHeaderLine('Content-Type', 'application/json'); $headers->addHeaderLine('X-Product-Information', base64_encode(json_encode(Moto\Application\Updates\Service::getProductInformation()))); } catch (\Exception $e) { } return true; } } 