<?php
 namespace Moto\Application\Installation; use Moto; use Zend\Db; class Processor { protected $_params = array(); protected $_options = array( 'ignoreExistsData' => false, 'firstUserRole' => 'root', ); protected $_databaseAdapter = null; protected $_language = null; protected $_user = null; protected $_errors = array(); protected $_services = array(); protected $_sqlParser = null; protected $_environment; protected $currentThemeName; public function __construct($request = null) { if (!empty($request)) { $request = $this->_validateRequest($request); } $this->setParams($request); Moto\Hook::trigger('Installer: Instance.created', $this); Moto\System\Log::debug('@INSTALLER : Instance created by ' . get_class($this)); } protected function _getRequestValidator() { return new Moto\Application\Installation\InputFilter\Process(); } protected function _validateRequest($request) { $filter = $this->_getRequestValidator(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } return $filter->getValues(); } public function getOption($name, $default = null) { return (array_key_exists($name, $this->_options) ? $this->_options[$name] : $default); } public function setOption($name, $value) { $this->_options[$name] = $value; return $this; } public function setParams($params) { if (!is_array($params)) { throw new \Exception('Bad params'); } $this->_params = $this->_merge($this->_params, $params); return $this; } public function getParams() { return $this->_params; } public function getParam($name, $default = null) { return Moto\Util::getValue($this->_params, $name, $default); } protected function _merge(array $a, array $b, $keepNumeric = false) { foreach ($b as $key => $value) { if (array_key_exists($key, $a)) { if (is_int($key) && !$keepNumeric) { $a[] = $value; } elseif (is_array($value) && is_array($a[$key])) { $a[$key] = static::_merge($a[$key], $value, $keepNumeric); } else { $a[$key] = $value; } } else { $a[$key] = $value; } } return $a; } public function canExecute() { $result = true; $result &= !empty($this->_params); $result &= !MOTO_INSTALLED; return $result; } protected function _getWebsiteDatabaseFiles() { static $collection; if ($collection) { return $collection; } $collection = new Moto\System\BaseCollection(); $themeName = $this->_getCurrentThemeName(); if ($themeName) { $collection->push([ 'path' => '@themes/' . $themeName . '/sql/data.sql', 'owner' => 'theme', 'type' => 'sql', ]); } $collection->push([ 'path' => '@installationDir/sql/structure.sql', 'error' => 'ERROR_MESSAGE.DATABASE.IMPORT_STRUCTURE', 'owner' => 'system', 'type' => 'sql', ]); $collection->push([ 'path' => '@installationDir/sql/data.sql', 'error' => 'ERROR_MESSAGE.DATABASE.IMPORT_DATA', 'owner' => 'system', 'type' => 'sql', ]); return $collection; } protected function _preCheckInstallation() { $themeName = $this->_getCurrentThemeName(); if (!$themeName) { throw new Moto\System\Exception('ERROR_MESSAGE.COULD_FIND_CURRENT_THEME'); } $themeDir = Moto\System::getAbsolutePath('@themes/' . $themeName); $sqlFile = $themeDir . '/sql/data.sql'; if (!file_exists($sqlFile)) { Moto\System\Log::critical('@INSTALL : Require file "' . Moto\Util::getRelativePath($sqlFile) . '" not exists'); throw new Moto\System\Exception('ERROR_MESSAGE.THEME_CONTENT_FILE_NOT_EXISTS'); } if (MOTO_INSTALLED) { if (!$this->getOption('ignoreExistsData', false)) { Moto\System\Log::error('@INSTALL : ALREADY INSTALLED'); throw new Moto\System\Exception('ERROR_MESSAGE.ALREADY_INSTALLED'); } } } protected function _executeMainPart() { $databaseOptions = Moto\Config::get('database', array()); $databaseOptions = array_merge($databaseOptions, $this->_params['database']); Moto\Config::set('database', $databaseOptions); Moto\System\Log::info('@INSTALL : Database Data Importing'); $this->_importDataBase(); Moto\System\Log::info('@INSTALL : Basic Database Imported'); $databaseAdapter = $this->getDatabaseAdapter(); Moto\Config::set('databaseAdapter', $databaseAdapter); Moto\Application\Model\AbstractTable::setDefaultAdapter($databaseAdapter); Moto\Application\Model\AbstractTable::setTablePrefix($this->_params['database']['prefix']); $this->_updateProductInformation(); Moto\System\Log::info('@INSTALL : Init Settings'); Moto\Website\Settings::init(); Moto\System\Log::info('@INSTALL : Load Extra Info'); $this->_loadExtraInfo(); $this->_createAdminUser(); Moto\System\Log::info('@INSTALL : Saving Website Settings'); $this->_saveWebsiteSetting(); Moto\System\Log::info('@INSTALL : Website Settings Saved'); Moto\System\Log::info('@INSTALL : Saving File Settings'); $this->_saveSettings(); Moto\System\Log::info('@INSTALL : File Settings Saved'); Moto\Website\Settings::loadData(true); } protected function _importThemeAndUpgradeContent() { Moto\System\Log::info('@INSTALL : Installing Content Taxonomy'); if (!Moto\Application\Content\TaxonomyProvider::install()) { Moto\System\Log::error('@INSTALL : Content Taxonomy Not Installed'); throw new \Exception('ERROR_MESSAGE.CONTENT_TAXONOMY_NOT_INSTALLED'); } Moto\System\Log::info('@INSTALL : Activating Theme'); if ($this->_activateTheme()) { Moto\System\Log::info('@INSTALL : Theme Activated'); } else { Moto\System\Log::error('@INSTALL : Theme Not Activated'); throw new \Exception('ERROR_MESSAGE.THEME_NOT_ACTIVATED'); } Moto\System\Log::info('@INSTALL : Migrate Blog To Content Sections'); Moto\Update\Upgrade::migrateBlogToContentSections(true); Moto\System\Log::info('@INSTALL : Installing Extra Content'); if ($this->_installContentSections()) { Moto\System\Log::info('@INSTALL : Extra Content Installed'); } else { Moto\System\Log::error('@INSTALL : Extra Content Not Installed'); throw new \Exception('ERROR_MESSAGE.EXTRA_CONTENT_NOT_INSTALLED'); } if ($this->_installNotFoundPopup()) { Moto\System\Log::info('@INSTALL : Not Found Popup Installed'); } else { Moto\System\Log::error('@INSTALL : Not Found Popup Not Installed'); throw new \Exception('ERROR_MESSAGE.EXTRA_CONTENT_NOT_INSTALLED'); } Moto\System\Log::info('@INSTALL : Installing Task Manager'); $migration = new Moto\System\Task\Database\DatabaseMigration(); if (!$migration->install()) { Moto\System\Log::error('@INSTALL : Task Manager Not Installed'); throw new \Exception('ERROR_MESSAGE.TASK_MANAGER_NOT_INSTALLED'); } Moto\System\Log::info('@INSTALL : Check and create audio player preset'); Moto\Update\Upgrade::checkAndCreateAudioPlayerPreset(); Moto\System\Log::info('@INSTALL : Check and create Social Links Extended preset'); Moto\Update\Upgrade::checkAndCreateSocialLinksExtendedPresets(); Moto\System\Log::info('@INSTALL : Check `Back To Top` button settings'); Moto\Update\Upgrade::upgradeBackToTopButton(); Moto\System\Log::info('@INSTALL : Check `Tabs` preset'); Moto\Update\Upgrade::checkAndCreateTabsPresets(); Moto\System\Log::info('@INSTALL : Check `Cookie Notification` preset'); Moto\Update\Upgrade::checkAndCreateCookieNotificationPresets(); Moto\System\Log::info('@INSTALL : Add system.engine'); $this->_installSystemEngine(); Moto\Website\Settings::loadData(true); Moto\System\Log::info('@INSTALL : Check and create password protected page'); Moto\Update\Upgrade::checkAndCreatePasswordProtectedPage(); Moto\System\Log::info('@INSTALL : Check and create under construction page'); Moto\Update\Upgrade::checkAndCreateUnderConstructionPage(); Moto\Update\Upgrade::checkAndUpgradeHomePageProvider(); Moto\System\Log::info('@INSTALL : Check and upgrade tabs presets for vertical mode'); Moto\Update\Upgrade::upgradeTabsPresetsForVerticalMode(); Moto\System\Log::info('@INSTALL : Check and create tile_gallery presets'); Moto\Update\Upgrade::checkAndCreateTileGalleryPresets(); Moto\System\Log::info('@INSTALL : Check and create post_tags presets'); Moto\Update\Upgrade::checkAndCreateTagListPresets(); Moto\System\Log::info('@INSTALL : Check and create category_list presets'); Moto\Update\Upgrade::checkAndCreateCategoryListPresets(); Moto\System\Log::info('@INSTALL : Check and create moto_callback presets'); Moto\Update\Upgrade::checkAndCreateMotoCallbackPresets(); $pageUpdated = Moto\Database\Models\Page::where('type', '=', 'blog.index')->update(array('name' => 'Blog Main Page')); if ($pageUpdated) { Moto\System\Log::notice('@INSTALL : rename Blog to Blog Main Page successfully'); } Moto\System\Log::info('@INSTALL : Check and create content_slider presets'); Moto\Update\Upgrade::checkAndCreateContentSliderPresets(); Moto\System\Log::info('@INSTALL : Check and create breadcrumbs presets'); Moto\Update\Upgrade::checkAndCreateBreadcrumbsPresets(); Moto\System\Log::info('@INSTALL : Upgrade breadcrumbs presets'); Moto\Update\Upgrade::upgradeBreadcrumbsPreset(); Moto\System\Log::info('@INSTALL : Check and create form_elements presets'); Moto\Update\Upgrade::checkAndCreateFormElementsPresets(); Moto\System\Log::info('@INSTALL : Upgrade content_slider presets'); Moto\Update\Upgrade::upgradeContentSliderPresetForAutoControls(); Moto\System\Log::info('@INSTALL : Upgrade blog.category_list presets'); Moto\Update\Upgrade::updateCategoryListPresetsForPostsCounter(); Moto\System\Log::info('@INSTALL : Upgrade text.table presets'); Moto\Update\Upgrade::checkAndCreateTablePresets(); Moto\System\Log::info('@INSTALL : Update divider presets for direction'); Moto\Update\Upgrade::updateDividerPresetsForDirections(); Moto\System\Log::info('@INSTALL : Update slider presets for thumbnail pagination'); Moto\Update\Upgrade::checkAndCreateBlogFiltersPresets(); Moto\System\Log::info('@INSTALL : Check and create filters presets for content sections'); Moto\Update\Upgrade::checkAndCreateCalendarPresets(); Moto\System\Log::info('@INSTALL : Check and create calendar presets for content sections'); } public function execute() { $resetInstallationOnFail = false; try { Moto\System\Style::setOption('deferredRebuildEnabled', false); $this->_preCheckInstallation(); Moto\System\Log::info('@INSTALL : Start'); Moto\Hook::trigger('Installer: executing', $this); $resetInstallationOnFail = true; $this->_executeMainPart(); Moto\Website\Settings::loadData(true); $this->_importThemeAndUpgradeContent(); Moto\Website\Settings::loadData(true); $this->_rebuild(); $this->_updateBrandInfo(); Moto\Hook::trigger('Installer: executed', $this); Moto\System\Log::info('@INSTALL : Done'); } catch (\Exception $e) { if (!$this->isError()) { if ($e instanceof \Zend\Db\Adapter\Exception\InvalidQueryException) { $this->_errors[] = $e->getPrevious() ? $e->getPrevious()->getMessage() : $e->getMessage(); } else { $this->_errors[] = $e->getMessage(); } } if ($resetInstallationOnFail) { $this->executingFailed(); } throw $e; } return true; } protected function executingFailed() { Moto\System\Log::critical('@INSTALL : Failed => reset settings.php'); $absolutePath = Moto\System::getAbsolutePath('@websiteSettings'); $content = file_get_contents($absolutePath); $content = Moto\System\ConfigFile::clearInstallationSettings($content); Moto\Util::filePutContents($absolutePath, $content); Moto\System\Cache\Cleaner::systemCacheFor([$absolutePath]); } public function getErrors() { return $this->_errors; } public function isError() { return (!empty($this->_errors)); } protected function _saveSettings() { $file = Moto\System::getAbsolutePath('@websiteSettings'); $userSettings = ''; foreach ($this->_params['database'] as $key => $value) { $userSettings .= '$config["database"]["' . $key . '"] = base64_decode(\'' . base64_encode($value) . '\');' . "\n"; } $content = file_get_contents($file); $content = Moto\System\ConfigFile::setupInstallation($content, $userSettings); Moto\Util::filePutContents($file, $content); Moto\System\Cache\Cleaner::systemCacheFor([$file]); return true; } protected function _importDataBase() { if ($this->isDataAlreadyExists() || MOTO_INSTALLED) { if (!$this->getOption('ignoreExistsData', false)) { throw new \Exception('ERROR_MESSAGE.DATABASE.DATA_ALREADY_EXISTS'); } } $collection = $this->_getWebsiteDatabaseFiles(); $files = $collection->filter(function ($item) { return (Moto\Util::getValue($item, 'owner') === 'system') && (Moto\Util::getValue($item, 'type') === 'sql'); }); $this->_executeSqlFiles($files); return true; } protected function _executeSqlFiles($files) { if (is_string($files)) { $files = (array) $files; } if (count($files) < 1) { return true; } $parser = $this->_getSqlParser(); $this->_executeQueries([ 'SET FOREIGN_KEY_CHECKS = 0', 'SET time_zone = "+00:00"', ]); $lastFile = null; foreach ($files as $file) { Moto\System\Log::debug('@INSTALL : import file "' . Moto\System::getRelativePath($file['path']) . '"'); $absolutePath = Moto\System::getAbsolutePath($file['path']); $relativePath = Moto\System::getRelativePath($file['path']); $lastFile = $relativePath; if (!file_exists($absolutePath)) { Moto\System\Log::critical('@INSTALL : Cant find required file "' . $relativePath . '"'); throw new Moto\Exception('ERROR_MESSAGE.DATABASE.FAILED_IMPORT_FILE', 500, [ 'file' => $relativePath, 'step' => 'Existing' ]); } $queries = $parser->parseFile($absolutePath); if (empty($queries)) { Moto\System\Log::critical('@INSTALL : Cant parse dump file "' . $relativePath . '"'); throw new Moto\Exception('ERROR_MESSAGE.DATABASE.FAILED_IMPORT_FILE', 500, [ 'file' => $relativePath, 'step' => 'Parsing' ]); } try { $status = $this->_executeQueries($queries); } catch (\Exception $e) { $status = false; $message = $e->getMessage(); $message = str_replace([ $this->getParam('database.hostname'), $this->getParam('database.username'), $this->getParam('database.password'), '127.0.0.1', ], '*****', $message); Moto\System\Log::critical('@INSTALL : Exception : [' . $e->getCode() . '] ' . $message, [ 'file' => $relativePath, 'step' => 'Executing' ]); } } $this->_executeQueries([ 'SET FOREIGN_KEY_CHECKS = 1', ]); if (!$status) { throw new Moto\Exception(Moto\Util::getValue($file, 'error', 'ERROR_MESSAGE.DATABASE.FAILED_IMPORT_FILE'), 500, [ 'file' => $lastFile, 'step' => 'Executing' ]); } return true; } protected function _getSqlParser() { if (null === $this->_sqlParser) { $this->_sqlParser = new Moto\Sql\Parser(); $this->_sqlParser->setTablePrefix($this->_params['database']['prefix']); } return $this->_sqlParser; } public function isDataAlreadyExists() { $databaseAdapter = $this->getDatabaseAdapter(); $sql = "SHOW TABLES LIKE '" . $this->_params['database']['prefix'] . "settings'"; $result = $databaseAdapter->query($sql)->execute(); return (boolean) $result->current(); } public function getDatabaseAdapter() { if (!$this->_databaseAdapter) { $databaseConfig = array_merge(Moto\Config::get('database'), $this->_params['database']); try { Moto\Hook::trigger('Installer: creatingDatabaseAdapter', $databaseConfig); $this->_databaseAdapter = new Db\Adapter\Adapter($databaseConfig); $schema = $this->_databaseAdapter->getCurrentSchema(); $isConnected = $this->_databaseAdapter->getDriver()->getConnection()->isConnected(); Moto\Database\Provider::initEloquent($this->_databaseAdapter, $databaseConfig); Moto\Hook::trigger('Installer: createDatabaseAdapter', $this->_databaseAdapter); } catch (\Exception $e) { throw new \Exception('ERROR_MESSAGE.DATABASE.CONNECT'); } } return $this->_databaseAdapter; } protected function _executeQueries($queries, $message = null) { $result = false; try { foreach ($queries as $query) { if (is_array($query)) { $query = (string) Moto\Util::getValue($query, 'sql'); } if (!is_string($query)) { continue; } $query = trim($query); if ($query === '') { continue; } $result = $this->_executeQuery($query); } } catch (\Zend\Db\Adapter\Exception\InvalidQueryException $e) { if (!empty($message)) { $this->setError($message); } throw $e; } catch (\Exception $e) { if (!empty($message)) { $this->setError($message); } throw $e; } return !!$result; } protected function _executeQuery($query) { if (is_array($query)) { $query = $query['sql']; } if (!is_string($query)) { return false; } $query = trim($query); if ($query === '') { return false; } $databaseAdapter = $this->getDatabaseAdapter(); $result = $databaseAdapter->query($query)->execute(); return !!$result; } public function setError($message, $namespace = null) { if ($namespace) { $this->_errors[$namespace] = $message; } else { $this->_errors[] = $message; } } protected function _loadExtraInfo() { $this->_language = Moto\Database\Models\Language::where('locale', $this->_params['language'])->first(); if (!$this->_language) { $this->_language = Moto\Database\Models\Language::find(1); } if ($this->_language) { $this->_params['admin']['language_id'] = $this->_language->id; } $role = Moto\Database\Models\Role::where('name', $this->getOption('firstUserRole'))->first(); if (!$role) { $role = Moto\Database\Models\Role::find(3); } if ($role) { $this->_params['admin']['role_id'] = $role->id; } } protected function _createAdminUser() { Moto\System\Log::info('@INSTALL : Creating Admin User'); $this->_user = Moto\Application\Users\Service::save($this->_params['admin']); Moto\Authentication\Service::setUser($this->_user); Moto\System\Log::info('@INSTALL : Admin User Created'); } protected function _saveWebsiteSetting() { if (!empty($this->_params['website.address']) && empty($this->_params['website']['address'])) { $this->_params['website']['address'] = $this->_params['website.address']; } $settings = array( 'website' => array( 'language_id' => $this->_language->id, 'language_code' => $this->_language->code, 'language_locale' => $this->_language->locale, 'seo_html_attribute_lang' => $this->_language->code, 'address' => $this->_params['website']['address'] ) ); Moto\Application\Settings\Service::save($settings); } protected function _activateTheme() { try { $collection = $this->_getWebsiteDatabaseFiles(); $files = $collection->filter(function ($item) { return (Moto\Util::getValue($item, 'owner') === 'theme') && (Moto\Util::getValue($item, 'type') === 'sql'); }); $this->_executeSqlFiles($files); $themeName = $this->_getCurrentThemeName(); Moto\System\Log::info('@INSTALL : Activate theme : ' . var_export($themeName, true)); Moto\Website\Theme::activate($themeName, 'install'); Moto\Update\Upgrade::upgradeResponsiveTextStyles(); Moto\Update\Upgrade::fixTextListStylesPrefix(); Moto\Website\Theme::init(); } catch (\Exception $e) { if ($e instanceof Moto\Exception) { $this->_errors[] = 'ERROR_MESSAGE.THEME_NOT_ACTIVATED'; if ($e->getMessage() === 'ERROR_MESSAGE.DATABASE.FAILED_IMPORT_FILE') { $this->_errors[] = 'ERROR_MESSAGE.DATABASE.IMPORT_DATA'; } else { $this->_errors[] = $e->getMessage(); } } Moto\System\Log::error(__CLASS__ . '->' . __FUNCTION__ . ': ' . $e->getMessage()); return false; } return true; } protected function _installContentSections() { try { Moto\System\Log::info('@INSTALL : CONTENT_SECTION : Start Check or Install [ Blog ]'); Moto\Website\Theme::importContentSections(null, 'blog'); Moto\System\Log::info('@INSTALL : CONTENT_SECTION : Done [ Blog ]'); } catch (\Exception $e) { Moto\System\Log::error(__CLASS__ . '->' . __FUNCTION__ . ': ' . $e->getMessage()); return false; } return true; } protected function _installNotFoundPopup() { try { Moto\System\Log::info('@INSTALL : Start Install [ NotFoundPopup ]'); $contentSectionHelper = new Moto\System\ContentSection\NotFoundPopupHelper(); $contentSectionHelper->checkOrInstall(); Moto\System\Log::info('@INSTALL : Done [ NotFoundPopup ]'); } catch (\Exception $e) { Moto\System\Log::error(__CLASS__ . '->' . __FUNCTION__ . ': ' . $e->getMessage()); return false; } return true; } protected function _installSystemEngine() { $engineType = Moto\Util::getValue($this->_params, 'productInfo.engine'); if (empty($engineType)) { $themeInfo = Moto\Website\Theme::getInfo(); $engineType = Moto\Util::getValue($themeInfo, 'engine', Moto\System\Engine::TYPE_WEBSITE_BUILDER); } $engine = Moto\System\Settings::getEngine(); if (!$engine->isExistsType($engineType)) { Moto\System\Log::warning('@INSTALL : UNKNOWN ENGINE TYPE ' . var_export($engineType, true) . ' => will use ' . Moto\System\Engine::TYPE_LANDING_BUILDER); $engineType = Moto\System\Engine::TYPE_LANDING_BUILDER; } if (!$engine->installEngine($engineType)) { Moto\System\Log::error('@INSTALL : CAN NOT INSTALL ENGINE TYPE'); } } protected function _rebuild() { try { } catch (\Exception $e) { return false; } return true; } protected function _updateProductInformation() { Moto\System\Log::info('@INSTALL : Update product information'); if (!Moto\System\ProductInformation::update(Moto\Util::getValue($this->_params, 'productInfo'))) { Moto\System\Log::critical('@INSTALL : Cant update product information'); } } protected function _updateBrandInfo() { try { Moto\Authentication\AuthenticationService::getInstance(); Moto\System\Brand::getInstance()->getUpdatedBrandInfo(); } catch (\Exception $e) { } } public function getEnvironment() { if ($this->_environment) { return $this->_environment; } $data = array( 'application' => [ 'processingMode' => $this->getProcessingMode(), ], 'html5Mode' => false, 'apiUrl' => 'api.php', 'env' => APPLICATION_ENV, 'environment' => array( 'php' => PHP_VERSION, 'engine' => array( 'build' => Moto\Version::getBuild(), 'version' => Moto\Version::getVersion(), ), 'website' => defined('WEBSITE_DIR') ? WEBSITE_DIR : null, 'web' => Moto\Util::getValue($_SERVER, 'DOCUMENT_ROOT'), 'os' => PHP_OS, ), 'externalModules' => Moto\Util::getValue(Moto\System::getConfig(), 'externalModules'), 'engine' => array( 'build' => Moto\Version::getBuild(), 'version' => Moto\Version::getVersion(), ), 'productInfo' => Moto\System\ProductInformation::getFromFile(), 'themesList' => $this->_getAvailableThemes(), 'currentTheme' => $this->_getCurrentTheme(), 'pluginsList' => $this->_getAvailablePlugins(), ); if (Moto\System::isDevelopmentStage()) { $data['__database_files__'] = $this->_getWebsiteDatabaseFiles()->toArray(); } $this->_environment = $data; return $data; } protected function _getAvailablePlugins() { $plugins = Moto\System\PluginManager::findLocalPlugins(); $pluginsList = array(); if ($plugins) { $pluginsList = $plugins->toArray(array('name', 'label', 'version', 'build', 'installed', 'activated')); } return $pluginsList; } protected function _getAvailableThemes() { try { $themesList = Moto\Application\Themes\Service::getList(); } catch (\Exception $e) { return null; } $themes = []; if ($themesList->meta->total) { foreach ($themesList->records as $record) { $theme = array( 'folder' => Moto\Util::getValue($record, 'name'), 'name' => Moto\Util::getValue($record, 'info.name'), 'template_id' => Moto\Util::getValue($record, 'info.template_id'), 'label' => Moto\Util::getValue($record, 'info.label'), 'build' => Moto\Util::getValue($record, 'info.build'), 'version' => Moto\Util::getValue($record, 'info.version'), ); $themes[] = $theme; } } return $themes; } protected function _getCurrentTheme() { $themes = $this->_getAvailableThemes(); if (empty($themes)) { return null; } return $themes[0]; } protected function _getCurrentThemeName() { if ($this->currentThemeName) { return $this->currentThemeName; } try { $themes = Moto\Application\Themes\Service::getList(); } catch (\Exception $e) { Moto\System\Log::warning('[Installation] Cant retrieve themes list'); return null; } if (!$themes || $themes->meta->total < 1) { return null; } $theme = array_shift($themes->records); $themeName = $theme['name']; if (defined('APPLICATION_ENV') && APPLICATION_ENV !== 'production') { $themeName = Moto\Config::get('__BuilderThemeName__', $themeName); } $this->currentThemeName = $themeName; Moto\System\Log::info('@INSTALL : Selected Installation Theme : ' . var_export($themeName, true)); return $themeName; } public function getProcessingMode() { return 'INSTALLATION'; } public function checkRequirements() { return Moto\Application\ServerTest\Service::checkRequirements(); } } 