<?php
 namespace Moto\Application\Installation; use Illuminate\Support\Carbon; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = null; protected static $_payload; protected static function authInstallationUser() { $gate = Moto\System::gate(); $gate->before(function ($user = null) { return true; }); $gate->setUserResolver(function () { $user = Moto\System::getUser(); if (!$user) { $userId = Moto\Util::getValue(static::$_payload, 'user.id'); if ($userId && Moto\System::isInstalled()) { $user = Moto\Database\Models\User::find($userId); Moto\Authentication\Service::setUser($user); } } if (!$user) { $user = User::getInstance(); } return $user; }); } public static function isAllowed($privilege) { return true; } public static function process($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } Moto\System\Exception::enableAutoLogging(); if (!empty($request['website']) && !empty($request['website']['address'])) { $request['website.address'] = $request['website']['address']; } if (empty($request['productInfo'])) { try { $request['productInfo'] = Moto\System\ProductInformation::getFromFile(); } catch (\Exception $e) { } } $processor = null; $errors = []; try { $timezone = null; if (function_exists('date_default_timezone_get')) { $timezone = @date_default_timezone_get(); } if (empty($timezone)) { $timezone = 'UTC'; } if (function_exists('date_default_timezone_set')) { @date_default_timezone_set($timezone); } static::authInstallationUser(); $processor = Moto\System::app('Installation.Application', $request); $result = $processor->execute(); return static::createResponseWithToken($result); } catch (\Exception $e) { Moto\System\Log::error('Exception : [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if ($e instanceof Moto\Exception) { $errors = $e->getErrors(); } } if (empty($errors) && $processor) { $errors = $processor->getErrors(); } Moto\System\Log::debug("\tErrors : " . print_r($errors, 1)); throw new Moto\System\Exception(Moto\System\Exception::ERROR_INSTALLATION_FAILED_MESSAGE, Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } protected static function createResponseWithToken($response, $lifetime = 3600) { $user = Moto\System::getUser(); $payload = [ 'productId' => Moto\System\ProductInformation::getProductId(), 'path' => md5(Moto\System::getAbsolutePath('@website')), 'theme' => Moto\Website\Settings::get('theme'), 'engine' => [ 'version' => Moto\System\Settings::get('version'), 'build' => Moto\System\Settings::get('build'), ], 'user' => [ 'id' => $user->id, 'name' => $user->name, 'email' => $user->email, ], ]; $now = Carbon::now('UTC'); $payload['created'] = $now->timestamp; $now->addSeconds($lifetime); $payload['expired'] = $now->timestamp; $payload['created_at'] = date('Y-m-d H:i:s', $payload['created']); $payload['expired_at'] = date('Y-m-d H:i:s', $payload['expired']); $token = Moto\System::encrypt($payload); return [ 'token' => $token, 'response' => $response, ]; } protected static function checkRequestToken($token = null) { if ($token === null) { $token = static::getRequest()->getParam('token'); } $payload = Moto\System::decrypt($token); if (!is_array($payload) || empty($payload)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, ['InvalidToken']); } $expired = (int) Moto\Util::getValue($payload, 'expired'); $now = Carbon::now('UTC'); if ($expired < 1 || $now->timestamp > $expired) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, ['ExpiredToken']); } $errors = []; if (Moto\System\ProductInformation::getProductId() !== Moto\Util::getValue($payload, 'productId')) { $errors['productId'] = [Moto\System\ProductInformation::getProductId(), Moto\Util::getValue($payload, 'productId')]; } if (Moto\Website\Settings::get('theme') !== Moto\Util::getValue($payload, 'theme')) { $errors['theme'] = [Moto\Website\Settings::get('theme'), Moto\Util::getValue($payload, 'theme')]; } if (Moto\System\Settings::get('version') !== Moto\Util::getValue($payload, 'engine.version')) { $errors['version'] = [Moto\System\Settings::get('version'), Moto\Util::getValue($payload, 'engine.version')]; } if (Moto\System\Settings::get('build') !== Moto\Util::getValue($payload, 'engine.build')) { $errors['build'] = [Moto\System\Settings::get('build'), Moto\Util::getValue($payload, 'engine.build')]; } if (!empty($errors)) { $errors = ['InvalidToken', 'InvalidProperties' => array_keys($errors)]; throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $errors); } static::$_payload = $payload; static::authInstallationUser(); return true; } public static function generateStyles() { if (!Moto\System::isInstalled()) { Moto\System\Log::debug('!Moto\System::isInstalled()'); throw new Moto\System\Exception('COMMON.MESSAGES.SYSTEM_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.CANT_GENERATE_WEBSITE_STYLES')); } $resolver = \Illuminate\Database\Eloquent\Model::getConnectionResolver(); if (!is_object($resolver)) { Moto\System\Log::debug('!is_object($Resolver)'); throw new Moto\System\Exception('COMMON.MESSAGES.SYSTEM_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.CANT_GENERATE_WEBSITE_STYLES')); } static::checkRequestToken(); $errors = []; try { Moto\System\Style::rebuildAll(true); return true; } catch (\Exception $e) { Moto\System\Log::error('Exception : [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if ($e instanceof Moto\Exception) { $errors = $e->getErrors(); } } Moto\System\Log::debug("\tErrors : " . print_r($errors, 1)); throw new Moto\System\Exception(Moto\System\Exception::ERROR_INSTALLATION_FAILED_MESSAGE, Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } public static function isInstalled() { return Moto\System::isInstalled(); } public static function installPlugin($name) { if (!Moto\System::isInstalled()) { throw new Moto\System\Exception('COMMON.MESSAGES.SYSTEM_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.SYSTEM_NOT_INSTALLED')); } static::checkRequestToken(); $plugin = Moto\System\PluginManager::findLocalPluginByName($name); if (!$plugin) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System\Exception::enableAutoLogging(); Moto\System\PluginManager::install($name); Moto\System\PluginManager::activate($name); return $plugin->toArray('@default'); } public static function installNextPlugin() { if (!Moto\System::isInstalled()) { throw new Moto\System\Exception('COMMON.MESSAGES.SYSTEM_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.SYSTEM_NOT_INSTALLED')); } static::checkRequestToken(); $plugins = Moto\System\PluginManager::findLocalPlugins()->getNotInstalled(); if (!$plugins->count()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return array( 'count' => ($plugins->count() - 1), 'installed' => $plugins->get(0)->getName(), 'plugin' => static::installPlugin($plugins->get(0)->getName()), ); } public static function removeTemporaryFiles() { if (!Moto\System::isInstalled()) { throw new Moto\System\Exception('COMMON.MESSAGES.SYSTEM_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.SYSTEM_NOT_INSTALLED')); } static::checkRequestToken(); $path = Moto\System::getAbsolutePath('@website/mt-install'); if (file_exists($path)) { @Moto\Util::deleteDir($path); } if (file_exists($path)) { throw new Moto\System\Exception('COMMON.MESSAGES.CANT_REMOVE_INSTALLATION_DIR', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.CANT_REMOVE_INSTALLATION_DIR')); } return true; } public static function checkRequirements() { $processor = Moto\System::app('Installation.Application'); if (!$processor) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $requirements = $processor->checkRequirements(); if ($requirements) { throw new Moto\System\Exception('COMMON.ERROR.TEST_FAILED', 200, $requirements); } return true; } } 