<?php
namespace Moto\Application\MediaLibrary\InputFilter; use Moto\InputFilter\AbstractInputFilter; use Zend\InputFilter\Exception; use Zend; use Moto; class StoreFile extends AbstractInputFilter { protected $_name = 'mediaLibraryItem.storeFile'; public function init() { $this->add([ 'name' => 'content', 'required' => true, 'filters' => [], 'validators' => [], ]); $this->add([ 'name' => 'encoding', 'required' => false, 'filters' => [ [ 'name' => Moto\Filter\DefaultFilter::class, 'options' => [ 'value' => 'none' ] ], ], 'validators' => [ [ 'name' => 'InArray', 'options' => [ 'haystack' => ['none', 'base64',] ], ], ], ]); $this->add([ 'name' => 'folder_id', 'required' => false, 'filters' => [ [ 'name' => Moto\Filter\DefaultFilter::class, 'options' => [ 'value' => 0 ] ], ['name' => 'StripTags'], ['name' => 'StringTrim'], ['name' => Moto\Filter\IntValue::class], ], 'validators' => [ [ 'name' => 'Digits', 'break_chain_on_failure' => true, ], [ 'name' => Moto\Validator\ParentId::class, 'options' => [ 'table' => Moto\Config::get('database.prefix') . 'media_folders', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter'), ], ], ], ]); $this->add([ 'name' => 'name', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ], 'validators' => [ [ 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => [ 'pattern' => '/^[^\/\'"<>`\\\]+$/', ] ], [ 'name' => Moto\Validator\FileExtension::class, 'options' => [ 'caseSensitive' => false, 'extensions' => Moto\Application\FileManager\Service::getAllowedFileExtensions(), ], ], ], 'break_on_failure' => true, ]); $this->add(array( 'name' => 'file_path', 'required' => true, 'filters' => [ ['name' => 'StripTags'], ['name' => 'StringTrim'], ['name' => 'StringToLower'], [ 'name' => Moto\Filter\SanitizeFileName::class, 'options' => [ 'generateName' => true, 'generateExtension' => false, ], ], array( 'name' => 'Callback', 'options' => array( 'callback' => function ($filename) { if (is_string($filename)) { $filename = date('Y/m') . '/' . $filename; } return $filename; }, ) ), array( 'name' => Moto\Filter\UniqueFileName::class, 'options' => [ 'baseDir' => '@userUploads', 'tryTimeStamp' => 'Y-m-d-H-i-s', ], ), ], 'validators' => [ [ 'name' => Moto\Validator\NiceFilepath::class, 'break_chain_on_failure' => true, ], [ 'name' => Moto\Validator\FileExtension::class, 'options' => [ 'caseSensitive' => true, 'extensions' => Moto\Application\FileManager\Service::getAllowedFileExtensions(), ], ], ], )); } public function setData($data) { if (is_array($data)) { $data['file_path'] = Moto\Util::getValue($data, 'name'); } return parent::setData($data); } }