<?php
namespace Moto\Application\Model; use ArrayObject; use Moto; use Zend\Db\Sql\Select; use Zend\Db\Sql\Sql; use Zend\Db\Sql\Update as SqlUpdateObject; use Zend\Db\TableGateway\AbstractTableGateway; use Zend\Db\TableGateway\Exception; use Zend\Db\TableGateway\Feature; class AbstractTable extends AbstractTableGateway { static protected $_tablePrefix = ''; static protected $_defaultAdapter; protected $_resultModel = false; protected $_usedResultModel = false; protected $_primaryKey = 'id'; protected $_defaultFieldsForSelect = array('*'); public function __construct() { $this->table = self::$_tablePrefix . $this->table; $adapter = self::$_defaultAdapter; if ($adapter == null) $adapter = Moto\Config::get('databaseAdapter'); $this->adapter = $adapter; if (0) { $this->featureSet = new Feature\FeatureSet(); $this->sql = new Sql($this->adapter, $this->table); if ($this->sql->getTable() != $this->table) { throw new Exception\InvalidArgumentException('The table inside the provided Sql object must match the table of this TableGateway'); } } $this->initialize(); } public function useResultAsModel($flag) { if ($flag) { $model = $this->_resultModel; if ($model != null) { $this->resultSetPrototype->setArrayObjectPrototype(new $model()); } } else { $this->resultSetPrototype->setArrayObjectPrototype(new ArrayObject(array(), ArrayObject::ARRAY_AS_PROPS)); } $this->_usedResultModel = $flag; } public function setResultModel($class) { $this->_resultModel = $class; } static function setTablePrefix($prefix) { self::$_tablePrefix = $prefix; } static function setDefaultAdapter($adapter) { self::$_defaultAdapter = $adapter; } public function insert($model) { $this->_beforeInsert($model); if (is_array($model)) { $data = $model; } elseif (!is_object($model)) { return false; } else { if (method_exists($model, 'toInsert')) { $data = $model->toInsert(); } elseif (method_exists($model, 'toArray')) { $data = $model->toArray(); } else { $data = (array) $model; } } $data = $this->_castToMysqlTypes($data); $result = parent::insert($data); if (!$result) { return false; } if (!empty($this->_primaryKey)) { if (is_array($model)) $model[$this->_primaryKey] = $this->getLastInsertValue(); else { $model->{$this->_primaryKey} = $this->getLastInsertValue(); } } $this->_postInsert($model); return $model; } protected function _beforeInsert($model) { } protected function _postInsert($model) { } public function update($model, $where = null) { $this->_beforeUpdate($model); if (!is_array($model)) { if (method_exists($model, 'toUpdate')) { $data = $model->toUpdate(); } elseif (method_exists($model, 'toArray')) { $data = $model->toArray(); } else { $data = (array)$model; } } else { $data = $model; } if (empty($data) || !is_array($data)) { return false; } if (null === $where) { $where = array( $this->_primaryKey => (is_array($model) ? $model[$this->_primaryKey] : $model->{$this->_primaryKey}) ); } $data = $this->_castToMysqlTypes($data); $result = parent::update($data, $where); $this->_postUpdate($model); return $result; } protected function _castToMysqlTypes($data) { if (!is_array($data)) { return $data; } foreach($data as $key => $value) { if (is_array($value) || is_object($value)) { $data[$key] = Moto\Util::toJson($value); } elseif (is_bool($value)) { $data[$key] = (int) $value; } } return $data; } protected function _beforeUpdate($model) { } protected function _postUpdate($model) { } protected function _getSelectJoined($where = null) { $select = new Select($this->table); if (null !== $where) { if ($where instanceof \Closure) { $where($select); } else { $select->where($where); } } return $select; } protected function _executeSelectJoined($select, $resultPrototype = null) { $statement = $this->adapter->getDriver()->createStatement(); $select->prepareStatement($this->adapter, $statement); if (null === $resultPrototype) { $resultPrototype = $this->resultSetPrototype; } $resultSet = clone $resultPrototype; $resultSet->initialize($statement->execute()); return $resultSet; } public function create($data = null) { $modelClass = $this->_resultModel; $model = new $modelClass(); if (is_array($data)) { $model->exchangeArray($data); } return $model; } protected function _getList($where = null, $fields = null, $order = array()) { $select = new Select($this->table); if (!empty($where)) { $select->where($where); } if (!is_array($fields) || empty($fields)) $fields = $this->_defaultFieldsForSelect; $select->columns($fields); if (is_array($order) && !empty($order)) $select->order($order); $records = $this->executeSelect($select); return $records->toArray(); } public function fetchFromResultSet(\Zend\Db\ResultSet\ResultSet $result) { $list = array(); if ($this->_resultModel) { foreach($result as $item) { $list[] = $item; } } else { $list = $result->toArray(); } return $list; } public function save($model) { $isNew = true; if (is_object($model)) { $isNew = empty($model->{$this->_primaryKey}); } elseif (is_array($model)) { $isNew = empty($model[$this->_primaryKey]); } if ($isNew) return $this->insert($model); else return $this->update($model); } public function getKeyName() { return $this->_primaryKey; } public function createUpdateObject() { $update = new SqlUpdateObject(); $update->table($this->getTable()); return $update; } public function getById($id) { $row = null; $id = $id * 1; if ($id) { $select = new Select($this->table); $select->where(array( 'id' => $id )); $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function deleteById($id) { $where = array( $this->_primaryKey => $id ); return parent::delete($where); } public function createSelect() { return new Select($this->table); } } 