<?php
 namespace Moto\Application\Pages\InputFilter; use Moto; use Zend\InputFilter\Exception; use Zend\InputFilter\InputFilterInterface; class SavePage extends NewPage { protected $_name = 'pages.save'; public function init() { parent::init(); $this->add(array( 'name' => 'id', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( "name" => "Digits", 'break_chain_on_failure' => true, ), array( 'name' => 'Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'pages', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter'), ) ) ), )); $this->_addElementUrl(); $this->add(array( 'name' => 'parent_id', 'required' => true, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Moto\Application\Pages\PageParentIdValidator' ) ), )); $this->add(array( 'name' => 'published', 'required' => false, 'validators' => array( array( 'name' => 'Date', 'options' => array( 'format' => 'Y-m-d H:i:s', ), ), ), )); $this->add(array( 'name' => 'title', 'required' => true, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'max' => 200, ), ), ), )); $this->add(new PageProperties(), 'properties'); $this->add(array( 'name' => 'styles', 'required' => false, 'allow_empty' => true, 'filters' => array( array( 'name' => 'Moto\Filter\DefaultFilter', 'options' => array( 'value' => '' ) ), ) )); $this->add(array( 'name' => 'background_id', 'required' => false, 'allow_empty' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'Digits', 'break_chain_on_failure' => true, ), array( 'name' => 'Moto\Validator\Db\RecordExists', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'styles', 'field' => 'id', 'allow_zero' => function ($value, $context) { if (empty($context['type'])) { return false; } $type = Moto\Website\PageType::get($context['type']); return $type->isPost(); }, 'where' => array( 'type' => 'background', ), ) ) ), )); $this->add(array( 'name' => 'taxonomies', 'required' => false, )); $this->add(array( 'name' => 'meta_properties', 'required' => false, )); } protected function _addElementUrl($currentId = 0) { $this->remove('url'); $this->add(array( 'name' => 'url', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), array('name' => 'StringToLower'), ), 'validators' => array( array( 'name' => 'Regex', 'break_chain_on_failure' => true, 'options' => array( 'pattern' => '/^([a-z0-9\_\-]{1,200})$/', ) ), array( 'name' => 'Moto\Application\Pages\PageParentUrlValidator', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'pages', 'field' => 'url', 'adapter' => Moto\Config::get('databaseAdapter'), 'exclude' => array( 'field' => 'id', 'value' => (int) $currentId, ) ) ) ), )); } public function setData($data) { if (!empty($data['id'])) { $this->_addElementUrl($data['id']); } $result = parent::setData($data); return $result; } public function getValues($keys = null, $ignoreDefault = false) { $values = parent::getValues($keys, $ignoreDefault); if (empty($values['layout'])) { unset($values['layout']); } if (empty($values['background_id'])) { if (!empty($values['type'])) { $type = Moto\Website\PageType::get($values['type']); if (!$type->isPost()) { unset($values['background_id']); } } else { unset($values['background_id']); } } return $values; } } 