<?php
 namespace Moto\Application\Pages; use Illuminate; use Moto; use Moto\Application\Content; use Moto\Application\Model\AbstractModel; use Zend; use Zend\Db\Sql\Select; class PageModel extends AbstractModel implements Moto\System\ContentSection\HasContentProviderInterface { const STATUS_PUBLISH = 'publish'; const STATUS_DRAFT = 'draft'; const VISIBILITY_PUBLIC = 'public'; const VISIBILITY_PASSWORD = 'password'; const VISIBILITY_PROTECTED = 'password'; const VISIBILITY_PRIVATE = 'private'; protected $_fields = array( 'id' => array( ), 'name' => array( 'default' => '' ), 'url' => array( 'default' => '' ), 'title' => array( 'default' => '' ), 'author_id' => array( 'default' => 1 ), 'parent_id' => array( 'default' => 0 ), 'category_id' => array( 'type' => 'int', 'default' => null, ), 'is_system' => array( 'default' => 0 ), 'content' => array( 'default' => '' ), 'type' => array( 'default' => 'page' ), 'status' => array( 'default' => 'draft' ), 'visibility' => array( 'default' => 'public' ), 'properties' => array( 'default' => '{}', 'type' => 'object', 'class' => 'Moto\Application\Pages\PageProperties' ), 'layout' => array( 'default' => '{"name":"default","sections":{"header":{"id":1,"visible":true},"footer":{"id":2,"visible":true}}}', 'type' => 'object', ), 'styles' => array( 'default' => '' ), 'relative_url' => array( 'virtual' => true, 'default' => null ), 'background' => array( 'default' => '' ), 'background_id' => array( 'default' => '' ), 'short_description' => array( 'default' => '' ), 'published' => array(), 'modified' => array(), 'created' => array(), ); public $properties; protected $_table; protected $_tableName = 'pages'; protected $_children = null; public $relative_url = null; protected $_sections = array(); protected $_template; protected $_eloquentModel; protected $_parents; protected $_authorModel; protected static $_tableInstance = Moto\Application\Pages\PagesTable::class; public function __construct() { if (Moto\Features::isEnabled('content_as_object')) { $this->_fields['content_data'] = array( 'default' => '{}', 'type' => 'array', ); $this->_fields['content_version'] = array( 'default' => 1, 'type' => 'int', ); } parent::__construct(); $this->created = date('Y-m-d H:i:s'); $this->published = $this->created; $this->modified = $this->created; $this->properties = new PageProperties(); $this->_table = Moto\System::getDbTable('pages'); } public function setName($value) { $this->set('name', $value); if (empty($this->title)) $this->set('title', $value); } protected function _updateDataBeforeSaving(array $data, $action) { if (!isset($data['properties'])) { $data['properties'] = array(); } if (!is_string($data['properties'])) { $data['properties'] = json_encode($data['properties']); } if (!isset($data['styles'])) { $data['styles'] = ''; } if (!is_string($data['styles'])) { $data['styles'] = json_encode($data['styles']); } if (!is_string($data['layout'])) { $data['layout'] = json_encode($data['layout']); } if (!Moto\Features::isEnabled('content_as_object')) { return $data; } if (array_key_exists('content', $data)) { if ($data['content'] === null) { $data['content'] = ''; } elseif (!is_string($data['content'])) { $data['content'] = Moto\Util::toJson($data['content'], '@content'); } } if (array_key_exists('content_data', $data)) { if ($data['content_data'] === null) { $data['content_data'] = '{}'; } else { $contentHelper = new Moto\Website\PageSectionContent(); $contentHelper->setRawContent($data['content_data']); $contentHelper->runSaving($action); $data['content_data'] = $contentHelper->toJson(); } $data['content_version'] = 2; } return $data; } public function toInsert() { if ($this->type == 'post') { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException(__METHOD__ . ' : invalid type value'); } $this->type = 'blog.post'; } $type = $this->getPageType(); if ($type->isPost() && ($this->parent_id * 1 < 1)) { $this->parent_id = $type->getMainPageId(); } $table = new Moto\Application\Styles\StylesTable(); $background = null; if (empty($this->background_id)) { if ($this->hasTemplate()) { $this->background_id = 0; } else { $background = $table->getDefaultByType('background'); $this->background_id = $background->id; } } else { $background = $table->getById($this->background_id); } if ($background) { $this->background = $background->class_name; } if (empty($this->author_id)) { $this->author_id = $this->_fields['author_id']['default']; } $data = parent::toInsert(); $data = $this->_updateDataBeforeSaving($data, 'insert'); return $data; } public function toUpdate() { if ($this->type == 'post') { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException(__METHOD__ . ' : invalid type value'); } $this->type = 'blog.post'; } $type = $this->getPageType(); if ($type->isPost() && ($this->parent_id * 1 < 1)) { $this->parent_id = $type->getMainPageId(); } $this->modified = date('Y-m-d H:i:s'); if ((empty($this->background) && !empty($this->background_id)) || $this->isModified('background_id')) { $table = new Moto\Application\Styles\StylesTable(); $background = $table->getById($this->background_id); if ($background) { $this->background = $background->class_name; } elseif ($this->hasTemplate()) { $this->background = ''; } } $data = parent::toUpdate(); $data = $this->_updateDataBeforeSaving($data, 'update'); return $data; } public function setFromRevision($revision) { $data = $revision->toArray(); unset($data['id']); unset($data['author_id']); unset($data['parent_id']); unset($data['type']); unset($data['published']); unset($data['modified']); unset($data['created']); unset($data['url']); unset($data['status']); unset($data['visibility']); $this->setFromArray($data); return $data; } public function exchangeArray($data) { $this->properties = new PageProperties(); if (array_key_exists('layout', $data) && is_string($data['layout'])) { $data['layout'] = \Zend\Json\Json::decode($data['layout']); } parent::exchangeArray($data); } public function getParentsRawData() { if (!$this->parent_id) { return null; } if ($this->_parents) { return $this->_parents; } $table = new PagesTable(); $branch = $table->getParentBranch($this->id); $this->_parents = []; foreach ($branch as $data) { $this->_parents[] = $data; } return $this->_parents; } public function getRelativeUrl() { if ($this->relative_url !== null) { return $this->relative_url; } $this->relative_url = ''; $isMainPage = $this->isMainPage(); $isParentRoot = !$isMainPage && $this->parent_id == 0; if ($isParentRoot) { $this->_setRelativeUrl($this->url); } else if (!$isMainPage) { $branch = (array) $this->getParentsRawData(); $fullUrl = ''; foreach ($branch as $parentPage) { $fullUrl .= $parentPage['url'] . '/'; } $this->_setRelativeUrl($fullUrl); } return $this->relative_url; } public function getInnerUrl() { if ($this->_inner_url === null) { $this->getRelativeUrl(); } return $this->_inner_url; } public function getId() { return $this->id; } protected function _setRelativeUrl($url) { $url = trim($url, ' /'); if (!empty($url) && ($this->type == 'post' || $this->type == 'blog.post')) { } $this->_inner_url = $url; $url = Moto\ClickAction\Page::buildUrl($url); $this->relative_url = $url; } public function getAbsoluteUrl($query = null) { $url = Moto\System::getAbsoluteUrl('@website') . $this->getRelativeUrl(); if (!empty($query)) { $url = Moto\Util::extendUrl($url, array('query' => $query), array('query' => 'join')); } return $url; } public function getFullUrl($query = null) { $url = Moto\System::getRelativeUrl($this->getRelativeUrl()); if (!empty($query)) { $url = Moto\Util::extendUrl($url, array('query' => $query), array('query' => 'join')); } return $url; } public function duplicate($onlyUrl = false) { $newPage = clone $this; $newPage->status = 'draft'; $select = new Select(Moto\Config::get('database.prefix') . $this->_tableName); $select->columns(array('url')); $select->where->equalTo('url', null); $select->where->equalTo('parent_id', $newPage->parent_id); $duplicateFilter = new Moto\Filter\Duplicate(array( 'duplicator' => array( 'name' => 'db', 'options' => array( 'suffix' => '-', 'select' => $select ) ) )); $newUrl = $duplicateFilter->filter($this->url); if (!$onlyUrl) { $lastIndex = $duplicateFilter->getLastIndex(); $newPage->name .= ' ' . $lastIndex; $newPage->title .= ' ' . $lastIndex; } $newPage->url = $newUrl; return $newPage; } public function __clone() { $this->properties = clone $this->properties; $this->_table = clone $this->_table; $this->id = null; $this->url = null; $this->is_system = 0; $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; } public function getChildren() { if (is_null($this->_children)) { $this->_getChildrenPages(); } return $this->_children; } protected function _getChildrenPages($id = null, $_ids = array()) { if (in_array($id, $_ids)) { throw new \Exception('COMMON.ERROR.BROKEN_TREE', 500); } $_ids[] = $id; if (empty($id)) { $id = $this->id; $_ids = array($id); } if (is_null($this->_children)) { $this->_children = array(); } $children = $this->_table->getChildren($id); if (!empty($children)) { $this->_children = array_merge($this->_children, $children); foreach ($children as $child) { $this->_getChildrenPages($child['id'], $_ids); } } } public function getPageType() { return Moto\Website\PageType::get($this->type); } public function getSection($sectionName) { if (!array_key_exists($sectionName, $this->_sections)) { $this->_sections[$sectionName] = null; if (!$this->hasSection($sectionName)) { return $this->_sections[$sectionName]; } $sectionId = $this->getSectionId($sectionName); if ($sectionId == 0 && $this->hasTemplate()) { $sectionId = $this->getTemplate()->getSectionId($sectionName); } $table = Moto\System::getDbTable('contentBlock'); $section = $table->getById($sectionId); if (!$section) { $sectionType = $this->_getSectionTypeByName($sectionName); $section = $table->getDefaultContentBlock($sectionType); } $this->_sections[$sectionName] = $section; } return $this->_sections[$sectionName]; } public function getSectionId($sectionName, $isRaw = false) { if ($this->isPost() && !$isRaw) { $template = $this->getTemplate(); if ($template) { return $template->getSectionId($sectionName); } return null; } if (isset($this->layout->sections->{$sectionName}) && isset($this->layout->sections->{$sectionName}->id)) { return $this->layout->sections->{$sectionName}->id; } } public function hasSection($sectionName) { if ($this->getSectionId($sectionName, true) === -1) { return false; } if (!$this->isTemplate() && $this->hasTemplate()) { return $this->getTemplate()->hasSection($sectionName); } return (isset($this->layout->sections->{$sectionName}) && ( $this->layout->sections->{$sectionName}->visible )); } public function setLayoutSectionSettings($sections) { if (!is_object($sections)) { return false; } $this->layout->sections = $sections; } public function getTemplate() { if ($this->_template !== null) { return $this->_template; } $this->_template = false; $type = $this->getPageType(); if ($type->isTemplate()) { return false; } $template = $this->properties->template; if (!empty($template)) { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException('Detected page with template by properties : ' . var_export($this->id, true)); } $table = Moto\System::getDbTable('pages'); $table->useResultAsModel(true); $this->_template = $table->getByUrl($template); return $this->_template; } if ($this->isPage()) { return false; } $provider = $type->getContentProvider(); if (!$provider) { if (Moto\System::isDevelopmentStage()) { throw new \RuntimeException('Detected post without provider : ' . var_export($this->id, true) . ' ' . var_export($this->type, true)); } return false; } $this->_template = $provider->findTemplateFor($this); return $this->_template; } public function isTemplate() { return $this->getPageType()->isTemplate(); } public function getContentProvider() { return $this->getPageType()->getContentProvider(); } public function isPost() { return $this->getPageType()->isPost(); } public function isPage() { return $this->getPageType()->isPage(); } public function hasTemplate() { return (is_object($this->getTemplate())); } protected function _getSectionTypeByName($sectionName, $layout = null) { $type = null; if (null === $layout) { $layout = $this->_getLayoutByName($this->layout->name); } if (!$layout) { return null; } for ($i = 0, $len = count($layout->sections); $i < $len; $i++) { if ($layout->sections[$i]->name == $sectionName) { return $layout->sections[$i]->type; } } return $type; } protected function _getLayoutByName($layoutName) { if (!is_string($layoutName)) { return null; } $settings = Moto\Config::get('settings'); $layouts = null; if (!empty($settings['website']['layouts'])) { $layouts = $settings['website']['layouts']; } if (!$layouts) { return null; } if (is_string($layouts)) { $layouts = json_decode($layouts); } if (!is_array($layouts)) return null; $layout = null; for ($i = 0, $len = count($layouts); $i < $len; $i++) { if ($layouts[$i]->name == $layoutName) { $layout = $layouts[$i]; break; } } return $layout; } public function setLayoutByName($layoutName) { if (!is_string($layoutName) || empty($layoutName)) { return false; } if ($this->layout->name == $layoutName) { return true; } $layout = $this->_getLayoutByName($layoutName); if (!$layout) { return false; } $this->layout->name = $layout->name; for ($i = 0, $len = count($layout->sections); $i < $len; $i++) { $section = $layout->sections[$i]; if (!isset($this->layout->sections->{$section->name})) { $this->layout->sections->{$section->name} = new \stdClass(); $this->layout->sections->{$section->name}->id = null; $this->layout->sections->{$section->name}->visible = true; } } return true; } public function isPublished() { return $this->status === self::STATUS_PUBLISH; } public function isPublicationDateInFuture() { return time() < strtotime($this->published); } public function isMainPage() { $app = Moto\System::app(); $homePageProvider = $app->make('HomePageProvider'); $application = $homePageProvider->getApplicationInstance(); if (!$application) { $application = $homePageProvider->getApplicationInstance('page'); } if (!$application) { return false; } return $application->isMainPage($this); } public function isNotFoundPage() { return ((int) Moto\Website\Settings::get('notfound_page_id') === (int) $this->id); } public function isExists() { $key = $this->_table->getKeyName(); return !empty($this->{$key}); } public function getCanonicalUrl() { $url = Moto\Util::getFromObjectDeep($this->properties, 'meta.canonical_url'); if (empty($url)) { $url = $this->getAbsoluteUrl(); } return $url; } public function _preSetFromArray($data) { if (array_key_exists('status', $data)) { if ($this->isMainPage() && $data['status'] != self::STATUS_PUBLISH) { throw new Moto\Json\Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('status' => array('MODULE.PAGES.MAIN_PAGE_CAN_NOT_BE_DRAFT_ERROR_MESSAGE'))); } if ($this->isNotFoundPage() && $data['status'] != self::STATUS_PUBLISH) { throw new Moto\Json\Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('status' => array('MODULE.PAGES.CURRENT_PAGE_CAN_NOT_BE_DRAFT_ERROR_MESSAGE'))); } } if (!empty($data['layout']) && is_array($data['layout'])) { $data['layout'] = json_decode(json_encode($data['layout'])); } return $data; } protected function _postSetFromArray($data) { if (!$this->isExists()) { $type = $this->getPageType(); if ($type->isPost() && !empty($this->layout->sections)) { foreach ($this->layout->sections as $sectionName => $section) { if (!empty($section->id) && $section->id <= 2) { $this->layout->sections->{$sectionName}->id = 0; } } } } } public function buildChildrenPlainTree() { $tree = array(); if (isset($this->id) && isset($this->url)) { $tree = $this->buildPlainTree($this->getChildren(), $this->url); } return $tree; } public function buildPlainTree(array $childrenList, $rootUrl = '') { if (empty($childrenList)) { return $childrenList; } $children = array(); foreach ($childrenList as $child) { $children[$child['id']] = $child; } $tree = array(); foreach ($children as $child) { $currentChild = $child; $childFullUrl = array(); do { $childFullUrl[] = $currentChild['url']; $parentId = $currentChild['parent_id']; $currentChild = isset($children[$parentId]) ? $children[$parentId] : null; } while ($currentChild); $childFullUrl[] = $rootUrl; $tree[implode('/', array_reverse($childFullUrl))] = $child; } return $tree; } public function save() { $this->_table->save($this); return true; } public function getAuthor() { if ($this->_authorModel) { return $this->_authorModel; } $user = null; $model = $this->getEloquentModel(); if ($model) { $user = $model->author; } if (!$user) { $user = Moto\Database\Models\User::find($this->author_id); } $this->_authorModel = $user; return $this->_authorModel; } public function getAuthorName($default = null) { return Moto\Util::getValue($this->getAuthor(), 'name', $default); } public function showComments() { return $this->getPageType()->getParam('show_comments', false) && $this->properties->show_comments; } public function getCommentsLanguage() { return $this->getPageType()->getParam('comments_language', 'en'); } public function getDateFormat() { return $this->getPageType()->getParam('date_format', 'Y-m-d'); } public function getBackgroundClass($default = 'moto-background') { if ($this->isTemplate()) { return $this->background; } if (!$this->background_id && $this->hasTemplate()) { return $this->getTemplate()->getBackgroundClass($default); } return $this->background; } public function getCodeInjection($section) { if (Moto\Website\Application::getInstance()->isPreviewMode() && !Moto\Website\Settings::get('custom_code_execution', true)) { return ''; } $code = ''; if ($this->hasTemplate()) { $code .= $this->getTemplate()->getCodeInjection($section); } $code .= $this->properties->getCodeInjection($section); return $code; } public function isCurrent($properties) { return (Moto\Util::getFrom($properties, 'id') == $this->id); } public function isProtectedContent() { return ($this->visibility !== static::VISIBILITY_PUBLIC); } public function getContentPassword() { if ($this->hasContentPassword()) { return $this->properties->getPassword(); } return Moto\Website\PasswordProtection::getPassword(); } public function hasContentPassword() { return $this->properties->hasPassword(); } public function isAllowViewContent($user = null) { if (!($this->isProtectedContent() && ($this->hasContentPassword() || Moto\Website\PasswordProtection::isEnabled()))) { return true; } return Moto\Website\PasswordProtection::isVerifiedPasswordHash($this->getContentPassword()); } public function getContentVersion() { return (property_exists($this, 'content_version') ? $this->content_version : 1); } public function loadRelation($relations) { $relations = (array) $relations; foreach ($relations as $relation => $handler) { if (is_numeric($relation)) { $relation = $handler; $handler = function () { }; } $attribute = $relation; if (is_array($handler)) { if (count($handler) > 1) { $attribute = $handler[1]; } $handler = $handler[0]; } $model = $this->getEloquentModel(); $model->load([$relation => $handler]); $this->{$attribute} = $model->{$relation}; } return $this; } public function resetEloquentModel() { $this->_eloquentModel = null; return $this; } public function setEloquentModel($model) { if ($this->_eloquentModel === $model) { return $this; } if (!$model instanceof Moto\Database\Models\Page) { throw new \InvalidArgumentException('Not supported Eloquent Model : ' . get_class($model)); } if ($this->_eloquentModel !== null) { throw new \RuntimeException('Eloquent Model already defined'); } if (((int) $this->id) !== $model->id) { throw new \RuntimeException('Eloquent model not equal with pag'); } $this->_eloquentModel = $model; if (!$model->exists || $this->isModified()) { Moto\Database\Models\Page::unguard(); if ($model->exists) { $attributes = $this->getModifiedFields(); } else { $attributes = $this->toArray(); } $attributes = Moto\Util::arrayExcept($attributes, [ 'relative_url', ]); $model->fill($attributes); Moto\Database\Models\Page::reguard(); } $relations = $model->getRelations(); foreach ($relations as $name => $data) { $this->{$name} = $data; } return $this; } public function getEloquentModel() { if ($this->_eloquentModel) { return $this->_eloquentModel; } if ($this->id > 0) { $model = Moto\Database\Models\Page::findOrNew($this->id); if (!$model->exists || $this->isModified()) { Moto\Database\Models\Page::unguard(); if ($model->exists) { $attributes = $this->getModifiedFields(); } else { $attributes = $this->toArray(); } $attributes = Moto\Util::arrayExcept($attributes, [ 'relative_url', ]); $model->fill($attributes); Moto\Database\Models\Page::reguard(); } $this->_eloquentModel = $model; } return $this->_eloquentModel; } public function onCreatedHandler() { } public function syncTaxonomies($taxonomies) { if ($taxonomies instanceof Illuminate\Support\Collection) { $taxonomies = $taxonomies->toArray(); } if (Illuminate\Support\Arr::isAssoc($taxonomies)) { $taxonomies = Illuminate\Support\Arr::flatten($taxonomies, 1); } $taxonomyIds = []; foreach ($taxonomies as $taxonomy) { if (is_numeric($taxonomy)) { $taxonomyId = $taxonomy; } else { $taxonomyId = Moto\Util::getValue($taxonomy, 'id'); } $taxonomyId = (int) $taxonomyId; if ($taxonomyId > 0) { $taxonomyIds[] = $taxonomyId; } } try { $query = Moto\Database\Models\ContentTaxonomyTag::query(); $query->whereIn('id', $taxonomyIds); $collection = $query->get(); $list = []; $position = 1; foreach ($taxonomyIds as $id) { $taxonomy = $collection->find($id); if (!$taxonomy) { continue; } $list[$id] = [ 'order_position' => $position++, ]; } $this->getEloquentModel()->taxonomies()->sync($list); } catch (\Exception $e) { Moto\System\Log::error('Exception on sync page taxonomies: [ ' . $e->getCode() . ' ] ' . $e->getMessage()); return false; } return true; } public function syncMetaProperties($input) { return $this->getEloquentModel()->syncMetaProperties($input); } public function onDeletingHandler() { $model = $this->getEloquentModel(); if ($model) { $model->fireModelEvent('deleting'); } } public function onDeletedHandler() { $model = $this->getEloquentModel(); if (!$model) { return; } $model->taxonomies()->detach(); $model->fireModelEvent('deleted', false); } public function onSavingHandler() { $this->getEloquentModel(); } public function onSavedHandler() { $model = $this->getEloquentModel(); if (!$model) { return; } $model->fireModelEvent('saved', false); return; $model->refresh(); $model->syncOriginal(); } public function getParentPage($columns = ['*']) { $model = $this->getEloquentModel(); if (!$model) { return null; } if (!$this->parent_id) { return null; } $parentPage = $model->getParentPage($columns); $page = new Moto\Application\Pages\PageModel(); $page->exchangeArray($parentPage->toArray()); Moto\Website\Pages::remember($page); return $page; } public function getCategoryModel() { $model = $this->getEloquentModel(); if ($model) { return $model->category; } return null; } public function getTaxonomiesModel() { $model = $this->getEloquentModel(); if ($model) { return $model->taxonomies; } return null; } } 