<?php
 namespace Moto\Application\Profile; use Moto; use Moto\Json\Server; use Moto\Json\Request; use Moto\Json\Response; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'profile'; protected static $_resourcePrivilegesMap = array( 'save' => 'set', 'get' => 'get', 'changePassword' => 'set', 'updatePreference' => 'set', 'updatePreferences' => 'set', ); public static function save($request = null) { $currentUser = static::requireCurrentUser(); if (null === $request) { $request = static::getRequest()->getParams(); } $request['id'] = $currentUser->id; $filter = new SaveProfileFilter(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $currentUser->fill($filter->getValues()); if (!$currentUser->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } static::_updateIdentity(); return $currentUser; } public static function get() { return static::requireCurrentUser(); } public static function changePassword($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new ChangePasswordFilter(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $authUser = static::requireCurrentUser(); $currentUser = Moto\Database\Models\User::find($authUser->id); if (!$currentUser) { throw new Moto\Json\Server\Exception(Moto\System\Exception::ERROR_AUTHORIZATION_DATA_MESSAGE, Moto\System\Exception::ERROR_AUTHORIZATION_DATA_CODE); } $filteredValues = $filter->getValues(); if (!$currentUser->isValidPassword($filteredValues['old_password'])) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('old_password' => array('MODULE.PROFILE.WRONG_PASSWORD_ERROR'))); } $currentUser->setPassword($filteredValues['new_password']); if (!$currentUser->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } static::_updateIdentity(); return true; } protected static function requireCurrentUser() { $user = Moto\Authentication\Service::getUser(); if (!$user) { throw new Moto\Json\Server\Exception(Moto\System\Exception::ERROR_AUTHORIZATION_DATA_MESSAGE, Moto\System\Exception::ERROR_AUTHORIZATION_DATA_CODE); } return $user; } protected static function _updateIdentity() { $user = Moto\Authentication\Service::getUser(); if (!$user) { return false; } $user = Moto\Database\Models\User::find($user->id); if (!$user) { return false; } Moto\Authentication\Service::updateUser($user); return true; } public static function updatePreference($namespace = null, $value = null) { $currentUser = static::requireCurrentUser(); if (null === $namespace) { $request = static::getRequest(); $namespace = $request->getParam('namespace'); $value = $request->getParam('value'); } $filter = new Moto\Application\Users\InputFilter\PreferencesFilter(); if (!$filter->hasInputFilter($namespace)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE, [ 'namespace' => $namespace, ]); } $input = $filter->getInputFilter($namespace); $input->setData($value); if (!$input->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $currentUser->updatePreference($namespace, $input->getValues(true)); $currentUser->save(); static::_updateIdentity(); return $currentUser; } public static function updatePreferences($request = null) { $currentUser = static::requireCurrentUser(); if (null === $request) { $request = static::getRequest()->getParams(); } $request = (array) $request; $filter = new Moto\Application\Users\InputFilter\PreferencesFilter([ 'enableInputs' => array_keys($request), ]); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $preferences = []; foreach ($filter->getInputs() as $namespace => $input) { $preferences[$namespace] = $input->getValues(true); } if (!empty($preferences)) { $currentUser->updatePreferences($preferences); } $currentUser->save(); static::_updateIdentity(); return $currentUser; } } 