<?php
 namespace Moto\Application\ServerTest; use Moto\Json\Server; use Zend\Db; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = null; public static function isAllowed($privilege) { return true; } public static function checkRequirements() { $result = array(); $errors = array(); $requirements = new Validator\Requirements(); $phpVersion = substr(PHP_VERSION_ID, 0, 3); $phpVersionRequirements = Moto\Config::get('serverRequirements.php_version.' . $phpVersion); if (empty($phpVersionRequirements)) { $errors[] = array( 'name' => 'PHP_VERSION', 'params' => array( 'level' => 'error', 'php_version' => PHP_VERSION ), ); } else { $requirements->addValidator('php_version', $phpVersionRequirements); } $files = Moto\Config::get('serverRequirements.files'); if (!empty($files) && is_array($files)) { foreach ($files as $name => $params) { if (null === $params) { continue; } $validator = 'file_writable'; if (empty($params['name'])) { $params['name'] = $name; } if ($name[0] === '@') { $path = Moto\System::getRelativePath($name); } elseif (preg_match('/^path\.(.*)/', $name, $match)) { $path = Moto\System::getRelativePath($match[1]); } else { $path = Moto\Config::get($name); } if (empty($params['type'])) { $params['type'] = 'file'; } if (empty($path)) { $params['level'] = 'error'; $errors[] = array( 'name' => 'FILE_WRITABLE', 'params' => $params ); continue; } $params['name'] = $path; if (!empty($params['validator'])) { $validator = $params['validator']; } $requirements->addValidator($validator, $params); } } $functions = Moto\Config::get('serverRequirements.functions'); if (!empty($functions) && is_array($functions)) { foreach ($functions as $name => $params) { if (null === $params) { continue; } if (empty($params['function'])) { $params['function'] = $name; } $requirements->addValidator('php_function_exists', $params); } } $extensions = Moto\Config::get('serverRequirements.extensions'); if (!empty($extensions) && is_array($extensions)) { foreach ($extensions as $name => $params) { if (null === $params) { continue; } if (empty($params['extension'])) { $params['extension'] = $name; } $requirements->addValidator('php_extension_loaded', $params); } } $validators = Moto\Config::get('serverRequirements.validators'); if (!empty($validators) && is_array($validators)) { foreach ($validators as $validator) { if (!is_array($validator) || empty($validator['type'])) { continue; } if (empty($validator['params'])) { $validator['params'] = array(); } $requirements->addValidator($validator['type'], $validator['params']); } } $requirements->addValidator('php_session_create'); $requirements->addValidator('php_safe_mode', array('level' => 'warning')); $requirements->addValidator('mail_function', array('level' => 'warning')); $requirements->addValidator('php_upload_enabled', array('level' => 'warning')); $requirements->addValidator('php_upload_file_size', array('level' => 'warning', 'min' => Moto\Config::get('serverRequirements.php_upload_file_size'))); require_once(Moto\System::getAbsolutePath('@phpLibrary/Getid3/getid3.php')); ob_start(); $error = null; try { $getID3 = new \getID3(); } catch (\Exception $e) { $error = array( 'name' => 'DEPENDENCY_GETID3_FAILED', 'params' => array( 'level' => 'error', 'message' => $e->getMessage(), ), ); } if ($error) { $errors[] = $error; } ob_get_clean(); if (!$requirements->isValid() || !empty($errors)) { $errors = array_merge($errors, $requirements->getErrors()); throw new Server\Exception('COMMON.ERROR.TEST_FAILED', 200, $errors); } return $result; } public static function checkDataBase($request = null) { if (Moto\System::isInstalled()) { throw new Moto\System\Exception('COMMON.MESSAGES.ALREADY_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array('ERROR_MESSAGE.ALREADY_INSTALLED')); } if (null === $request) { $request = static::getRequest()->getParams(); } $errors = []; $filter = new InputFilter\DataBase(); $filter->setData($request); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $databaseConfig = array_merge(Moto\Config::get('database'), $filter->getValues()); $isConnected = false; $schema = null; try { $databaseAdapter = new Db\Adapter\Adapter($databaseConfig); $schema = $databaseAdapter->getCurrentSchema(); $isConnected = $databaseAdapter->getDriver()->getConnection()->isConnected(); $charset = Moto\Database\Provider::DEFAULT_CHARSET; $sql = "SHOW CHARACTER SET WHERE CHARSET = '$charset';"; $queryResult = $databaseAdapter->query($sql)->execute(); if ($queryResult->count() < 1) { $errors['dependencies']['charset'] = $charset; $errors['charset'] = $charset; } $requiredEngineExists = false; $sql = 'SHOW ENGINES'; $queryResult = $databaseAdapter->query($sql)->execute(); foreach ($queryResult as $value) { if (Moto\Util::getValue($value, 'Engine') === Moto\Database\Provider::DEFAULT_ENGINE) { $requiredEngineExists = true; break; } } if (!$requiredEngineExists) { $errors['dependencies']['engine'] = Moto\Database\Provider::DEFAULT_ENGINE; $errors['engine'] = Moto\Database\Provider::DEFAULT_ENGINE; } if (count($errors)) { throw new Server\Exception(Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $errors); } } catch (\Exception $e) { if ($e instanceof Moto\Exception) { throw $e; } $errors['exception'] = [ 'code' => $e->getCode(), 'message' => $e->getMessage() ]; switch ($e->getCode()) { case 2001: case 2002: case 2003: case 2005: case 2006: $errors['hostname'] = ['MODULE.INSTALL.ERROR_MESSAGE.DATABASE.HOSTNAME_CONNECTION_FAILED']; break; case 1049: $errors['database'] = ['MODULE.INSTALL.ERROR_MESSAGE.DATABASE.DATABASE_NOT_FOUND']; break; case 1044: case 1045: case 1227: case 1698: case 1873: case 3118: case 3202: case 3630: case 3879: case 3957: $errors['username'] = ['MODULE.INSTALL.ERROR_MESSAGE.DATABASE.ACCESS_DENIED']; $errors['password'] = ['MODULE.INSTALL.ERROR_MESSAGE.DATABASE.ACCESS_DENIED']; break; } throw new Server\Exception('COMMON.ERROR.TEST_FAILED', $e->getCode(), $errors); } return $isConnected; } } 