<?php
namespace Moto\Application\Styles; use Moto\Json\Request; use Moto\Json\Server; use Moto\Json\Response; use Moto\Application\Styles\InputFilter; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'styles'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'get', 'getColorTheme' => 'get', 'rebuildStyles' => 'set', ); public static function getList($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (!($request instanceof Request\Collection)) $request = new Request\Collection($request); $table = new StylesTable(); $styles = $table->getList($request); if (!$styles) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $result = new Response\Collection($styles); return $result; } public static function save($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $addNew = false; if (empty($request['id'])) { if (empty($request['class_name'])) { $addNew = true; } else { $stylesTable = new StylesTable(); $style = $stylesTable->getByClassName($request['class_name']); if ($style) { $request['id'] = Moto\Util::getValue($style, 'id'); } else { $addNew = true; } } } $result = $addNew ? static::_addStyle($request) : static::_updateStyle($request); if ($result) { Moto\System\Style::rebuildAll(); } return $result; } protected static function _addStyle($data) { $filter = new InputFilter\NewStyle(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new StylesTable(); $style = new StyleModel(); $style->setFromArray($values); $style = $table->save($style); return $style; } protected static function _updateStyle($data) { $filter = new InputFilter\SaveStyle(); $filter->setData($data); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $table = new StylesTable(); $table->useResultAsModel(true); $style = $table->getById($values['id']); if (!$style) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $style->setFromArray($values); $table->save($style); return $style; } public static function getById($id) { $id = (int) $id; $table = new StylesTable(); $style = $table->getById($id); if (!$style) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $style; } public static function duplicate($id) { $table = new StylesTable(); $table->useResultAsModel(true); $style = $table->getById($id); if (!$style) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $newStyle = $table->duplicate($style); $table->insert($newStyle); Moto\System\Style::rebuildAll(); return $newStyle; } public static function delete($id) { $id = (int) $id; $stylesTable = new StylesTable(); $style = $stylesTable->getById($id); if (!$style || $style->is_system) { throw new Server\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $result = $stylesTable->deleteById($style->id); if ($result) { $body = $stylesTable->getBody(); $pagesTable = new Moto\Application\Pages\PagesTable(); $pagesTable->update(array( 'background_id' => $body['id'], 'background' => $body['class_name'], ), array( 'background_id' => $style->id ), true); Moto\System\Style::rebuildAll(); } return $result; } public static function setColorTheme($request = null) { if (null === $request) $request = static::getRequest()->getParams(); if (empty($request)) { return false; } $colors = json_encode($request); Moto\Website\Settings::set('colors', $colors); Moto\System\Style::rebuildAll(); return $request; } public static function getColorTheme() { $result = Moto\Website\Settings::get('colors'); if (is_string($result)) { $result = json_decode($result); } if (empty($result)) { $result = array('base' => new \stdClass(), 'custom' => new \stdClass()); } return $result; } public static function rebuildStyles() { Moto\System\Style::rebuildAll(); return true; } } 