<?php
 namespace Moto\Application\Styles; use Moto; use Zend\Db\Sql\Select; use Moto\Application\Model\AbstractTable; use Zend\Db\ResultSet\ResultSet; class StylesTable extends AbstractTable { protected $table = 'styles'; protected $_resultModel = 'Moto\Application\Styles\StyleModel'; protected $_primaryKey = 'id'; public function fetchAll() { $resultSet = $this->select(); return $resultSet; } public function getList($request = null) { $select = new Select($this->table); $select->columns(array( 'count' => new \Zend\Db\Sql\Expression("COUNT(*)") )); $statement = $this->sql->prepareStatementForSqlObject($select); $result = $statement->execute()->current(); $total = $result['count']; $select->columns(array('id', 'name', 'class_name', 'type', 'is_system', 'is_responsive', 'properties', 'link', 'modified', 'created')); $select->order(array('id' => 'DESC')); $records = $this->fetchFromResultSet($this->executeSelect($select)); $result = array( 'meta' => array( 'total' => $total, 'limit' => 0, 'page' => 0, ), 'records' => $records ); return $result; } public function getById($id) { $row = null; if (is_numeric($id)) { $select = new Select($this->table); $select->where(array( 'id' => $id )); $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function getBody() { $select = new Select($this->table); $select->where(array( 'name' => 'Body', )); return $this->executeSelect($select)->current(); } public function getByClassName($className) { $row = null; if (is_string($className)) { $select = new Select($this->table); $select->where(array( 'class_name' => $className )); $resultSet = $this->executeSelect($select); $row = $resultSet->current(); } return $row; } public function isSystem($id) { $row = is_numeric($id); if ($row) { $select = new Select($this->table); $select->where(array( 'id' => $id, 'is_system' => '1' )); $resultSet = $this->executeSelect($select); $row = !!$resultSet->current(); } return $row; } public function deleteById($id) { $where = array( $this->_primaryKey => $id ); return parent::delete($where); } public function deleteByClassName($className) { $where = array( 'class_name' => $className ); return $this->delete($where); } protected function generateClassName($type, $id, $isSystem = false) { if ($isSystem) { return 'moto-' . $type . '_system_' . Moto\Util::getUniqueId(); } return 'moto-' . $type . '_' . $id; } protected function _postInsert($model) { if (is_array($model)) { if (empty($model['class_name'])) { $model['class_name'] = $this->generateClassName(Moto\Util::getValue($model, 'type'), Moto\Util::getValue($model, 'id'), Moto\Util::getValue($model, 'is_system', false)); } } elseif (is_object($model)) { if (empty($model->class_name)) { $model->class_name = $this->generateClassName(Moto\Util::getValue($model, 'type'), Moto\Util::getValue($model, 'id'), Moto\Util::getValue($model, 'is_system', false)); } } $this->save($model); } public function duplicate($style) { $newStyle = clone $style; $newStyle->id = null; $newStyle->is_system = 0; $newStyle->class_name = ''; $uniqueNameFilter = new Moto\Filter\Duplicate(array( 'duplicator' => array( 'name' => 'db', 'options' => array( 'table' => Moto\Config::get('database.prefix') . 'styles', 'field' => 'name', 'where' => array( 'type' => $style->type ) ) ) )); $newStyle->name = $uniqueNameFilter->filter($newStyle->name); return $newStyle; } public function getDefaultByType($type) { $type = (string)$type; $select = new Select($this->table); $select->where(array( 'type' => $type, 'is_system' => true, )); $select->order(array('id' => 'ASC')); $select->limit(1); return $this->executeSelect($select)->current(); } } 