<?php
namespace Moto\Application\Updates; use Moto\Json\Server; use Moto; class Service extends Moto\Service\AbstractStaticService { const ERROR_BAD_RESPONSE_MESSAGE = 'ERROR_BAD_RESPONSE_MESSAGE'; const ERROR_BAD_RESPONSE_CODE = 500; protected static $_resourceName = 'updates'; protected static $_resourcePrivilegesMap = array( 'getInfo' => 'get', 'getActionsForUpdate' => 'get', ); protected static $_releaseInfoFile = 'release.json'; protected static $_releaseFile = 'release.zip'; protected static $_themeSuffix = '_latest.zip'; protected static $_pluginSuffix = '_next.zip'; protected static $_releaseInfo = null; protected static $_updaterInstance = array(); protected static $_updaterClassMap = array( 'engine' => Moto\Update\UpdaterEngine::class, 'theme' => Moto\Update\UpdaterTheme::class, 'plugin' => Moto\Update\UpdaterPlugin::class, ); protected static $_remoteUpdateRequest = array( 'httpMethod' => 'GET', 'postLikeJson' => false, 'checking' => null, ); public static function getInfo($request = null) { $currentBuild = (int) Moto\System\Settings::get('build'); $currentVersion = Moto\System\Settings::get('version'); $engineUpdates = static::_getReleaseInfo('engine'); $nextEngineUpdate = Moto\Util::getValue($engineUpdates, 'next', array()); $latestBuild = (int) Moto\Util::getValue($nextEngineUpdate, 'build'); $info = array( 'engine' => array( 'version' => $currentVersion, 'build' => $currentBuild, 'update' => ($latestBuild > $currentBuild), 'next' => Moto\Util::arrayOnly($nextEngineUpdate, array('version', 'build', 'description', 'dateReleased', 'downloadable', 'releaseNote',)), 'last' => Moto\Util::arrayOnly($nextEngineUpdate, array('version', 'build', 'description', 'dateReleased',)), ), 'brand' => Moto\System\Brand::getInstance()->getUpdatedBrandInfo(), 'productInformation' => static::getProductInformation(), 'themes' => static::_checkThemesUpdates(), 'plugins' => static::_getPluginsUpdates(), 'subscription' => static::_getReleaseInfo('subscription'), 'informers' => static::_getReleaseInfo('informers'), ); if (is_array($nextEngineUpdate) && !empty($nextEngineUpdate)) { $engineNextUpdateItem = Moto\Util::arrayOnly($nextEngineUpdate, array('version', 'build', 'dateReleased', 'url', 'fileinfo', 'hash', 'min_engine_version', 'min_engine_build')); $engineNextUpdateItem['type'] = 'engine'; $engineNextUpdateItem['name'] = 'core'; $engineNextUpdateItem['archivePath'] = '@updateTemp/' . static::$_releaseFile; $engineNextUpdateItem['timestamp'] = time(); $engineNextUpdateItem['from'] = array( 'version' => $currentVersion, 'build' => $currentBuild, ); $info['engine']['next']['update_item'] = Moto\System::encrypt($engineNextUpdateItem); } return $info; } public static function getBrand($request = null) { return Moto\System\Brand::getInstance()->getUpdatedBrandInfo(); } protected static function _checkThemesUpdates($themes = null) { $updates = array(); if (!is_array($themes)) { $themes = static::_getReleaseInfo('themes'); } if (!is_array($themes)) { return array(); } $themes = (array) $themes; foreach ($themes as $name => $themeUpdates) { if (!is_array($themeUpdates)) { continue; } $themeInfo = Moto\Website\Theme::getInfo($name); if (is_null($themeInfo)) { continue; } if (!isset($themeUpdates['next']['build']) || !isset($themeUpdates['next']['min_engine_build'])) { continue; } if ($themeUpdates['next']['build'] <= $themeInfo['build']) { continue; } $themeInfo = Moto\Util::arrayOnly($themeInfo, array('name', 'label', 'version', 'build', 'template_id')); $themeInfo['next'] = new Moto\Application\Updates\ThemeUpdateItem($themeInfo, $themeUpdates['next']); if (is_array($themeUpdates['last'])) { $themeInfo['last'] = Moto\Util::arrayOnly($themeUpdates['last'], array('build', 'version', 'min_engine_version', 'min_engine_build')); } $updates[$name] = $themeInfo; } return $updates; } protected static function _getPluginsUpdates() { $result = array(); $updates = (array) static::_getReleaseInfo('plugins'); $localPlugins = Moto\System\PluginManager::findLocalPlugins(); if (!$localPlugins) { return array(); } foreach ($localPlugins as $localPlugin) { $pluginName = $localPlugin->getName(); $update = Moto\Util::getValue($updates, $pluginName); $itemInfo = $localPlugin->toArray('@default'); $itemInfo['folder'] = $localPlugin->getPath(); if (!$update) { $result[$pluginName] = $itemInfo; continue; } if (array_key_exists('next', $update) && is_array($update['next'])) { $itemInfo['next'] = Moto\Util::arrayOnly($update['next'], array('build', 'version', 'min_engine_version', 'min_engine_build', 'downloadable')); $nextUpdateItem = Moto\Util::arrayOnly($update['next'], array('version', 'build', 'dateReleased', 'url', 'fileinfo', 'hash', 'min_engine_version', 'min_engine_build')); $itemInfo['next']['compatibleVersion'] = true; $requiredEngineBuild = (int) Moto\Util::getValue($update['next'], 'min_engine_build'); if ($requiredEngineBuild) { $itemInfo['next']['compatibleVersion'] = ($requiredEngineBuild <= Moto\Version::getCurrentBuild()); } if ($itemInfo['next']['compatibleVersion']) { $nextUpdateItem['type'] = 'plugin'; $nextUpdateItem['name'] = $itemInfo['name']; $nextUpdateItem['min_engine_build'] = $requiredEngineBuild; $nextUpdateItem['archivePath'] = '@updateTemp/plugin_' . md5($pluginName) . '__' . Moto\Util::getValue($nextUpdateItem, 'build', 'next') . '.zip'; $nextUpdateItem['timestamp'] = time(); $nextUpdateItem['from'] = $localPlugin->toArray(array('version', 'build')); $itemInfo['next']['update_item'] = Moto\System::encrypt($nextUpdateItem); } } if (array_key_exists('last', $update) && is_array($update['last'])) { $itemInfo['last'] = Moto\Util::arrayOnly($update['last'], array('build', 'version', 'min_engine_version', 'min_engine_build')); } $result[$pluginName] = $itemInfo; } return array_values($result); } public static function getActionsForUpdate($request = null) { if (null === $request) { $request = static::getRequest()->getParams(); } $updateItem = Moto\Util::getValue($request, 'update'); $updateItem = Moto\System::decrypt($updateItem); if (!is_array($updateItem)) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } $updateType = Moto\Util::getValue($updateItem, 'type'); $itemName = Moto\Util::getValue($updateItem, 'name'); switch ($updateType) { case 'engine': $steps = array( 'downloadArchive', 'checkRequirements', 'extractArchive', 'checkFiles', 'enableMaintenance', 'createBackup', 'updateFiles', 'clearSystemCache', 'updateDatabase', 'cleanCache', 'optimizeStyles', 'rebuildStyles', 'disableMaintenance', 'finishUpdate', 'saveCurrentBuild' ); break; case 'plugin': $steps = Moto\System\PluginManager::getUpdateSteps($itemName); break; default: throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'UNKNOWN_ITEM_TYPE', 'type' => $updateType, 'item' => $itemName, ) )); break; } return array( 'steps' => $steps, ); } public static function checkDatabaseSupportsUTF8mb4() { if (!Moto\Database\Util::isSupportsCharset('utf8mb4')) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, array( array( 'name' => 'DATABASE_NOT_SUPPORTS_UTF8MB4', ) )); } } public static function download($request = null) { $updatedFile = null; $nextUpdate = null; static::_checkRequirements(); if (null === $request) { $request = static::getRequest()->getParams(); } $updateItem = Moto\Util::getValue($request, 'update'); $updateItem = Moto\System::decrypt($updateItem); $updateType = Moto\Util::getValue($updateItem, 'type'); $itemName = Moto\Util::getValue($updateItem, 'name'); switch ($updateType) { case 'engine': $engineUpdates = static::_getReleaseInfo('engine', true); $nextUpdate = Moto\Util::getValue($engineUpdates, 'next'); if (!is_array($nextUpdate)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, array( array( 'name' => 'BROKEN_RELEASE_INFO_FILE', 'type' => $updateType, 'item' => $itemName, ) )); } if ($nextUpdate['build'] >= 150) { static::checkDatabaseSupportsUTF8mb4(); } $updatedFile = Moto\Util::getValue($updateItem, 'archivePath'); if (!$updatedFile) { $updatedFile = '@updateTemp/' . static::$_releaseFile; } break; case 'theme': if (!preg_match('/^[a-z0-9\_\-]+$/i', $itemName)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'THEME_NAME_NOT_VALID', 'type' => $updateType, 'item' => $itemName, ) )); } $itemInfo = Moto\Website\Theme::getInfo($itemName); if (!is_array($itemInfo)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'THEME_NAME_NOT_EXISTS', 'type' => $updateType, 'item' => $itemName, ) )); } $nextUpdate = Moto\System\UpdateManager::getThemeNextUpdate($itemInfo); $updatedFile = Moto\Util::getValue($updateItem, 'archivePath'); if (!$updatedFile) { $updatedFile = '@updateTemp/' . $itemName . static::$_themeSuffix; } break; case 'plugin': $itemInfo = Moto\System\PluginManager::findLocalPluginByName($itemName); if (!$itemInfo) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'PLUGIN_NOT_EXISTS', 'type' => $updateType, 'item' => $itemName, ) )); } $nextUpdate = Moto\System\UpdateManager::getPluginNextUpdate($itemName); $updatedFile = Moto\Util::getValue($updateItem, 'archivePath'); if (!$updatedFile) { $updatedFile = '@updateTemp/plugin_' . md5($itemName) . '__' . Moto\Util::getValue($updateItem, 'build', 'next') . '.zip'; } break; default: throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'UNKNOWN_ITEM_TYPE', 'type' => $updateType, 'item' => $itemName, ) )); break; } if (!is_array($nextUpdate)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'CANT_FIND_UPDATE', 'type' => $updateType, 'item' => $itemName, ) )); } $url = Moto\Util::getValue($nextUpdate, 'url'); if (empty($url)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, array( array( 'name' => 'CANT_DETECT_RELEASE_URL', 'type' => $updateType, 'item' => $itemName, ) )); } static::_checkRequirementsByReleaseInfo($nextUpdate); $absoluteUpdatedFile = Moto\System::getAbsolutePath($updatedFile); clearstatcache(true, $absoluteUpdatedFile); $currentFileInfo = static::_getReqFileInfo($absoluteUpdatedFile, $nextUpdate['fileinfo']); if ($currentFileInfo['downloaded']) { return $currentFileInfo; } if ($currentFileInfo['remaining_download'] <= 0) { if ($currentFileInfo['remaining_download'] < 0) { Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] downloaded file biggest that need'); } else { Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] hash of downloaded file invalid'); } Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] dump ', array( 'url' => $url, 'current' => Moto\Util::arrayOnly($currentFileInfo, array('download_size', 'hash')), 'required' => $nextUpdate['fileinfo'], )); Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] try to download again'); @unlink($absoluteUpdatedFile); } $client = new Moto\Http\Client($url, array( 'streamtmpdir' => '@updateTemp', )); $range = null; $currentFileSize = 0; if (file_exists($absoluteUpdatedFile)) { $currentFileSize = filesize($absoluteUpdatedFile); $range = $currentFileSize . '-'; } if (is_string($range)) { $client->setOptions(array( 'curloptions' => array( CURLOPT_RANGE => $range, ), )); } $client->setStream(true); static::_updateHttpClient($client); $client->send(); $client->getAdapter()->close(); if ($client->hasErrors()) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, $client->getErrors()); } $httpResponse = $client->getResponse(); $body = $httpResponse->getBody(); clearstatcache(true, $absoluteUpdatedFile); if (file_exists($absoluteUpdatedFile)) { $destination = fopen($absoluteUpdatedFile, 'r+b'); fseek($destination, $currentFileSize); } else { $destination = fopen($absoluteUpdatedFile, 'w+b'); } fwrite($destination, $body); fclose($destination); usleep(50); clearstatcache(true, $absoluteUpdatedFile); $currentFileInfo = static::_getReqFileInfo($absoluteUpdatedFile, $nextUpdate['fileinfo']); if ($currentFileInfo['downloaded']) { return $currentFileInfo; } if ($currentFileInfo['remaining_download'] > 0) { Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] downloaded part of file', array( 'current' => Moto\Util::arrayOnly($currentFileInfo, array('downloaded_size', 'hash')), 'required' => $nextUpdate['fileinfo'], )); return $currentFileInfo; } if ($currentFileInfo['remaining_download'] < 0) { Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] downloaded file biggest that need'); } else { Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] hash of downloaded file invalid'); } Moto\System\Log::debug('[Update::' . __FUNCTION__ . '] dump ', array( 'url' => $url, 'current' => Moto\Util::arrayOnly($currentFileInfo, array('download_size', 'hash')), 'required' => $nextUpdate['fileinfo'], )); @unlink($absoluteUpdatedFile); throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 500, array( array( 'name' => 'BROKEN_ZIP_ARCHIVE', 'type' => $updateType, 'item' => $itemName, ) )); } protected static function _getReqFileInfo($path, $meta, $downloaded = null) { $fileSize = (file_exists($path) ? filesize($path) : 0); $needSize = $meta['size']; if (!is_bool($downloaded)) { $downloaded = static::_isDownloadedFileValid($path, $meta); } $response = array( 'downloaded' => $downloaded, 'download_size' => $needSize, 'downloaded_size' => $fileSize, 'remaining_download' => $needSize - $fileSize, 'hash' => null, ); if ($response['remaining_download'] === 0) { if (!empty($meta['md5'])) { $response['hash']['md5'] = md5_file($path); } if (!empty($meta['sha1'])) { $response['hash']['sha1'] = sha1_file($path); } } return $response; } public static function install($request = null) { $updater = null; if (null === $request) { $request = static::getRequest()->getParams(); } $updateItem = Moto\Util::getValue($request, 'update'); $updateItem = Moto\System::decrypt($updateItem); $updateType = Moto\Util::getValue($updateItem, 'type'); $itemName = Moto\Util::getValue($updateItem, 'name'); $updateOptions = array(); switch ($updateType) { case 'theme': if (!preg_match('/^[a-z0-9\_\-]+$/i', $itemName)) { throw new Server\Exception('COMMON.ERROR.DOWNLOAD_FAILED', 400, array( array( 'name' => 'THEME_NAME_NOT_VALID' ) )); } $updateOptions['theme'] = $itemName; $updateOptions['themeSuffix'] = static::$_themeSuffix; break; default: throw new Server\Exception('COMMON.ERROR.INSTALL_FAILED', 400, array( array( 'name' => 'UNKNOWN_ITEM_TYPE', 'type' => $updateType, ) )); break; } $result = null; $updater = static::_getUpdaterInstance($updateType); if (!$updater) { throw new Server\Exception('UPDATE.FAILED.UNKNOWN_UPDATER', 404, array('type' => $updateType)); } try { $updater->setOptions($updateOptions); $updater->setUpdateItem($updateItem); $result = $updater->execute(); } catch (\Exception $e) { $result = false; } if (!$result) { throw new Server\Exception('UPDATE.FAILED', 200, $updater->getErrors()); } return $result; } public static function executeAction($request = null) { $filter = new InputFilter\ExecuteAction(); $filter->setData(static::getRequest()->getParams()); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(); $updateItem = Moto\Util::getValue($request, 'update'); $updateItem = Moto\System::decrypt($updateItem); $updateType = Moto\Util::getValue($updateItem, 'type'); $params = Moto\Util::getValue($request, 'params'); if ($params) { $params = Moto\System::decrypt($params); } if ($updateType === 'engine' && Moto\Util::getValue($updateItem, 'build') >= 150) { static::checkDatabaseSupportsUTF8mb4(); } $updater = static::_getUpdaterInstance($updateType); if (!$updater) { throw new Server\Exception('UPDATE.FAILED.UNKNOWN_UPDATER', 404, array( 'type' => $updateType, )); } $response = array( 'status' => true, 'action' => $request['action'], ); try { $updater->setUpdateItem($updateItem); $response['result'] = $updater->executeAction($request['action'], $params); $response['next'] = $updater->getNextRequest($request['action'], $params); if (Moto\Util::arrayHas($response, 'next.params')) { $response['next']['params'] = Moto\System::encrypt($response['next']['params']); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::critical(__CLASS__ . '::' . __FUNCTION__ . ' catch exception "' . $e->getMessage() . '"', array( 'request' => $request, 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), ) )); } $response['status'] = false; } if (!$response['status']) { throw new Server\Exception('UPDATE.FAILED', 200, $updater->getErrors()); } return $response; } protected static function _getUpdaterInstance($type) { $type = strtolower($type); if (array_key_exists($type, static::$_updaterInstance)) { return static::$_updaterInstance[$type]; } $className = Moto\Util::getValue(static::$_updaterClassMap, $type, ''); if (is_string($className) && class_exists($className)) { $instance = new $className(); static::$_updaterInstance[$type] = null; if ($instance instanceof Moto\Update\Core) { static::$_updaterInstance[$type] = $instance; } } else { return null; } return static::$_updaterInstance[$type]; } protected static function _isDownloadedFileValid($file, $fileInfo) { if (!file_exists($file)) { return false; } if (!is_array($fileInfo)) { return false; } $isValid = true; if (!empty($fileInfo['size'])) { $isValid &= ($fileInfo['size'] === filesize($file)); } if (!empty($fileInfo['md5'])) { $isValid &= ($fileInfo['md5'] === md5_file($file)); } if (!empty($fileInfo['sha1'])) { $isValid &= ($fileInfo['sha1'] === sha1_file($file)); } $isValid = (boolean) $isValid; return $isValid; } protected static function _getReleaseInfo($type = '', $force = false) { if (static::$_releaseInfo === null || $force) { static::$_releaseInfo = static::_getLatestReleaseInfo(); } switch ($type) { case 'engine': $info = Moto\Util::getValue(static::$_releaseInfo, 'updates.engine'); break; case 'themes': $info = Moto\Util::getValue(static::$_releaseInfo, 'updates.themes'); break; case 'plugins': $info = Moto\Util::getValue(static::$_releaseInfo, 'updates.plugins'); break; case 'subscription': $info = Moto\Util::getValue(static::$_releaseInfo, 'subscription'); break; case 'informers': $info = Moto\Util::getValue(static::$_releaseInfo, 'informers'); break; default: $info = static::$_releaseInfo; } return $info; } protected static function _checkRequirements() { $requirements = new Moto\Application\ServerTest\Validator\Requirements(); if (!file_exists(Moto\System::getAbsolutePath('@updateTemp'))) { @mkdir(Moto\System::getAbsolutePath('@updateTemp')); } $requirements->addValidator('php_extension_loaded', array('extension' => 'curl')); $requirements->addValidator('file_writable', array('name' => Moto\System::getRelativePath('@updateTemp'), 'type' => 'folder')); $requirements->addValidator('disk_free_space', array('enough_space' => Moto\Config::get('serverRequirements.enough_disk_space'))); if (!$requirements->isValid()) { $errors = $requirements->getErrors(); throw new Server\Exception('COMMON.ERROR.TEST_FAILED', 200, $errors); } return true; } protected static function _checkRequirementsByReleaseInfo($releaseInfo) { if (!isset($releaseInfo['requirements'])) { return true; } $errors = array(); $validator = new Moto\Application\ServerTest\Validator\Requirements(); $requirements = $releaseInfo['requirements']; if (isset($requirements['php_version'])) { $phpVersionKey = substr(PHP_VERSION_ID, 0, 3); $phpVersionRequirements = Moto\Util::getFromArrayDeep($requirements, 'php_version.' . $phpVersionKey); if (empty($phpVersionRequirements)) { $errors[] = array( 'name' => 'PHP_VERSION', 'params' => array( 'level' => 'error', 'php_version' => PHP_VERSION ), ); } else { $validator->addValidator('php_version', $phpVersionRequirements); } } if (isset($requirements['enough_disk_space'])) { $validator->addValidator('disk_free_space', array('enough_space' => $requirements['enough_disk_space'])); } if (isset($requirements['extensions'])) { $extensions = $requirements['extensions']; if (!empty($extensions) && is_array($extensions)) { foreach ($extensions as $name => $params) { if (null === $params) { continue; } if (empty($params['extension'])) { $params['extension'] = $name; } $validator->addValidator('php_extension_loaded', $params); } } } if (isset($requirements['functions'])) { $functions = $requirements['functions']; if (!empty($functions) && is_array($functions)) { foreach ($functions as $name => $params) { if (null === $params) { continue; } if (empty($params['function'])) { $params['function'] = $name; } $validator->addValidator('php_function_exists', $params); } } } if (!$validator->isValid() || !empty($errors)) { $errors = array_merge($errors, $validator->getErrors()); throw new Server\Exception('COMMON.ERROR.TEST_FAILED', 200, $errors); } return true; } protected static function _getRequestParams() { $theme = Moto\Website\Settings::get('theme'); $themeInfo = Moto\Website\Theme::getInfo($theme); $timezone = null; if (function_exists('date_default_timezone_get')) { $timezone = @date_default_timezone_get(); } $websitePath = Moto\System::getAbsolutePath('@website'); $data = array( 'theme' => $theme, 'website' => Moto\Website\Settings::get('address'), 'host' => Moto\System\Request::getHttpHost(), 'ip' => Moto\System\Request::getIp(), 'build' => Moto\System\Settings::get('build'), 'version' => Moto\System\Settings::get('version'), 'time' => time(), 'product_id' => Moto\Config::get('__product_id__'), 'template_id' => Moto\Util::getValue($themeInfo, 'template_id', ''), 'theme_version' => Moto\Util::getValue($themeInfo, 'version', ''), 'theme_build' => Moto\Util::getValue($themeInfo, 'build', ''), 'website_path' => $websitePath, 'brand' => Moto\Util::getValue(Moto\System\Brand::getInstance()->getInfo(), 'name', 'motocms'), 'php' => PHP_VERSION, 'mysql' => Moto\Util::getValue(Moto\System::getDatabaseInformation(), 'serverVersion'), 'engine' => Moto\Util::getValue(Moto\System\Settings::getEngine()->getPublicData(), 'type', ''), ); $checking = Moto\Util::getValue(static::$_remoteUpdateRequest, 'checking'); if (!is_array($checking)) { $checking = array(); } if (in_array('php', $checking)) { $data['php'] = array( 'version' => PHP_VERSION, 'os' => PHP_OS, 'memory_limit' => @ini_get('memory_limit'), 'timezone' => $timezone, ); } if (in_array('mysql', $checking)) { $data['mysql'] = Moto\Util::arrayOnly(Moto\System::getDatabaseInformation(), array('driverName', 'serverVersion')); } if (in_array('server', $checking)) { $data['server'] = array( 'disk_free_space' => disk_free_space($websitePath), 'disk_total_space' => disk_total_space($websitePath), ); $env = array( 'HTTP_USER_AGENT', 'DOCUMENT_ROOT', 'REQUEST_SCHEME', 'GATEWAY_INTERFACE', 'SERVER_ADDR', 'SERVER_SIGNATURE', 'SERVER_SOFTWARE', 'SERVER_PROTOCOL', 'SERVER_PORT', ); foreach ($env as $name) { if (empty($_SERVER[$name])) { continue; } $data['server'][$name] = $_SERVER[$name]; } } return $data; } protected static function _getLatestReleaseInfo() { return Moto\System\UpdateManager::getAllUpdates(); } public static function getProductInformation() { $user = Moto\Authentication\Service::getUser(); $template = Moto\Website\Theme::getInfo(); $brandInfo = Moto\System\Brand::getInstance()->getInfo(); $engineInfo = Moto\System\Settings::getEngine()->getPublicData(); $engineInfo['version'] = Moto\Version::getCurrentVersion(); $engineInfo['build'] = Moto\Version::getCurrentBuild(); $engineInfo['brand'] = Moto\Util::getValue($brandInfo, 'name', 'motocms'); $databaseInfo = Moto\System::getDatabaseInformation(); $response = array( 'version' => 1, 'productId' => Moto\Config::get('__product_id__'), 'engine' => $engineInfo, 'user' => array( 'email' => $user->email, 'locale' => $user->language_code, ), 'server' => array( 'ipServer' => Moto\Util::getValue($_SERVER, 'SERVER_ADDR'), 'hostName' => Moto\System\Request::getHttpHost(), 'ipUser' => Moto\System\Request::getIp(), 'hostDir' => Moto\Util::getValue($_SERVER, 'DOCUMENT_ROOT'), 'mysqlVersion' => Moto\Util::getValue($databaseInfo, 'serverVersion'), 'phpVersion' => PHP_VERSION, 'timestamp' => time(), ), 'template' => array( 'id' => Moto\Util::getValue($template, 'template_id'), ), 'website' => array( 'url' => Moto\System::getAbsoluteUrl(), 'locale' => Moto\Website\Settings::get('language_code'), ), ); return $response; } protected static function _updateHttpClient($client) { if (!$client) { return false; } try { $headers = $client->getRequest()->getHeaders(); } catch (\Exception $e) { } return true; } public static function cancelUpdate() { $filter = new InputFilter\CancelUpdate(); $filter->setData(static::getRequest()->getParams()); if (!$filter->isValid()) { throw new Server\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(); $updateItem = Moto\Util::getValue($request, 'update'); $updateItem = Moto\System::decrypt($updateItem); $updateType = Moto\Util::getValue($updateItem, 'type'); $updater = static::_getUpdaterInstance($updateType); if (!$updater) { throw new Server\Exception('UPDATE.FAILED.UNKNOWN_UPDATER', 404, array( 'type' => $updateType, )); } $response = array( 'status' => true, ); try { $updater->setUpdateItem($updateItem); $response['result'] = $updater->executeAction('canceling', []); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::critical(__CLASS__ . '::' . __FUNCTION__ . ' catch exception "' . $e->getMessage() . '"', array( 'request' => $request, 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), ) )); } $response['status'] = false; } if (!$response['status']) { throw new Server\Exception('UPDATE.FAILED', 200, $updater->getErrors()); } return $response; } } 