<?php
namespace Moto\Application\Updates; use Moto; use JsonSerializable; class ThemeUpdateItem implements JsonSerializable { protected $_attributes = [ 'uid' => '', 'type' => 'theme', 'name' => null, 'downloadable' => false, 'build' => null, 'version' => null, 'min_engine_version' => null, 'min_engine_build' => 0, 'step' => 'preparing', 'completed' => false, 'theme' => null, 'update' => null, 'dependencies' => [ 'total' => 0, 'downloaded' => 0, 'installed' => 0, 'items' => [], ], 'steps' => [ 'preparing' => [ 'next' => 'download', 'completed' => false, ], 'download' => [ 'next' => 'install', 'completed' => false, ], 'install' => [ 'next' => 'cleaning', 'completed' => false, ], 'cleaning' => [ 'next' => null, 'completed' => false, ], ], ]; protected $_appends = [ 'steps', 'payload', 'progress', ]; protected $_hidden = []; protected $_visible = [ 'uid', 'type', 'name', 'version', 'build', 'min_engine_version', 'min_engine_build', 'downloadable', 'completed', 'step', ]; protected $_updater; public function __construct($theme = [], $update = []) { if (!empty($theme)) { $this->setThemeData($theme); } if (!empty($update)) { $this->setUpdateData($update); } } public function setThemeData($theme) { if ($this->_attributes['theme']) { return false; } if (!is_array($theme) || empty($theme)) { return false; } $theme = Moto\Util::arrayOnly($theme, ['name', 'label', 'version', 'build', 'template_id']); if (count($theme) !== 5) { return false; } $this->_attributes['theme'] = $theme; $this->_attributes['name'] = $theme['name']; return true; } public function setUpdateData($update) { if (!$this->theme) { return false; } if (!is_array($update) || empty($update)) { return false; } $required = Moto\Util::arrayOnly($update, ['name', 'build', 'version', 'min_engine_version', 'min_engine_build',]); if (count($required) !== 5) { return false; } if ($this->_attributes['name'] !== $update['name']) { return false; } if (!array_key_exists('file_size', $update)) { $update['file_size'] = Moto\Util::getValue($update, 'fileinfo.size'); } if (!array_key_exists('file_md5', $update)) { $update['file_md5'] = Moto\Util::getValue($update, 'fileinfo.md5'); } $this->_attributes['update'] = $update; $this->build = $update['build']; $this->version = $update['version']; $this->min_engine_version = $update['min_engine_version']; $this->min_engine_build = $update['min_engine_build']; $this->downloadable = (boolean) Moto\Util::getValue($update, 'downloadable', $this->downloadable); return true; } public function getStepsAttribute($value) { if (is_array($value)) { $value = array_keys($value); } else { $value = null; } return $value; } public function getUidAttribute($value) { if (!$this->_attributes['uid']) { $uid = null; $theme = $this->theme; $update = $this->update; if ($theme && $update) { $microtime = (string) microtime(true); $microtime = str_replace('.', '', $microtime); $uid = $theme['name'] . '_' . $theme['build'] . '-' . $update['build'] . '_' . base_convert($microtime, 10, 32); } $this->_attributes['uid'] = $uid; } return $this->_attributes['uid']; } public function getRawPayloadAttribute() { $user = Moto\System::getUser(); $payload = [ 'uid' => $this->uid, 'type' => $this->type, 'name' => $this->name, 'step' => $this->step, 'update' => $this->_attributes['update'], 'theme' => $this->_attributes['theme'], 'user_id' => Moto\Util::getValue($user, 'id'), 'created_at' => time(), ]; return $payload; } public function getPayloadAttribute() { $payload = $this->getRawPayloadAttribute(); return Moto\System::encrypt($payload); } public function getProgressAttribute() { return Moto\Util::arrayOnly($this->dependencies, ['total', 'downloaded', 'installed',]); } public static function isValidUid($uid) { if (!is_string($uid) || !preg_match('/^[a-z0-9\_\-]{8,64}$/i', $uid)) { return false; } return true; } public static function getStorageFilePath($uid) { if (!static::isValidUid($uid)) { return null; } return '@updateTemp/theme_' . $uid . '.json'; } public function delete() { $filePath = static::getStorageFilePath($this->uid); $absoluteFilePath = Moto\System::getAbsolutePath($filePath); if (file_exists($absoluteFilePath)) { @unlink($absoluteFilePath); } return true; } public function save() { $this->updateDependencies(); $filePath = static::getStorageFilePath($this->uid); $absoluteFilePath = Moto\System::getAbsolutePath($filePath); $attributes = $this->_attributes; $dependencies = $attributes['dependencies']; foreach ($dependencies['items'] as $index => $dependency) { if (!is_object($dependency['instance'])) { continue; } $dependency = [ 'progress' => $dependency['instance']->getProgress(), 'provider' => get_class($dependency['instance']), 'attributes' => $dependency['instance']->toArray(), 'instance' => null, ]; $dependencies['items'][$index] = $dependency; } $attributes['dependencies'] = $dependencies; $payload = [ 'attributes' => $attributes, ]; $payload = Moto\System::encrypt($payload); $content = [ 'version' => 1, 'updated_at' => time(), 'payload' => $payload, ]; $content = json_encode($content, JSON_PRETTY_PRINT); return (boolean) Moto\Util::filePutContents($absoluteFilePath, $content); } public static function find($uid) { if (!static::isValidUid($uid)) { return false; } $filePath = static::getStorageFilePath($uid); $absoluteFilePath = Moto\System::getAbsolutePath($filePath); if (!file_exists($absoluteFilePath) || !is_readable($absoluteFilePath)) { return false; } $content = file_get_contents($absoluteFilePath); $content = json_decode($content, true); if (!is_array($content)) { return false; } $payload = Moto\Util::getValue($content, 'payload'); $payload = Moto\System::decrypt($payload); if (!$payload) { return false; } $attributes = Moto\Util::getValue($payload, 'attributes'); if (!is_array($attributes)) { return false; } $item = new static(); $item->fill($attributes); return $item; } public static function factory($input) { $uid = $input; if (is_array($input)) { if (Moto\Util::getValue($input, 'step') === 'preparing') { return static::createForPreparing($input); } $uid = Moto\Util::getValue($input, 'uid'); } return static::find($uid); } public static function createForPreparing($data) { if (!is_array($data) || empty($data['uid']) || empty($data['theme']) || empty($data['update']) || empty($data['user_id'])) { return false; } if (!is_array($data['theme']) || !is_array($data['update'])) { return false; } $item = new static(); $item->setAttribute('uid', $data['uid']); if (!$item->setThemeData($data['theme'])) { return false; } if (!$item->setUpdateData($data['update'])) { return false; } if (!$item->save()) { return false; } return $item; } public function selfExecute() { $stepName = $this->step; $step = Moto\Util::getValue($this->_attributes['steps'], $stepName); if (!$step) { throw new Moto\Exception('Unknown step "' . $stepName . '"'); } $method = 'execute' . Moto\Util::toStudlyCase($stepName) . 'Step'; if (!method_exists($this, $method)) { throw new Moto\Exception('Cant execute step "' . $stepName . '"', 404, [ [ 'name' => 'THEME_UPDATE_CAN_BE_EXECUTED', 'params' => [ 'step' => $stepName ], ], ]); } try { $result = $this->{$method}(); } catch (\Exception $e) { $errors = []; if ($e instanceof Moto\System\Exception) { $errors = $e->getErrors(); } Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Exception "' . $e->getMessage() . '"', [ 'method' => $method, 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), ], ]); $errors[] = [ 'name' => 'THEME_UPDATE_EXECUTING_STEP_FAILED', 'params' => [ 'step' => $stepName, ], ]; throw new Moto\System\Exception('Failed on executing step "' . $stepName . '"', 500, $errors); } $nextName = Moto\Util::getValue($result, 'next'); if (!is_string($nextName)) { $nextName = Moto\Util::getValue($step, 'next'); } $this->step = $nextName; if ($this->step) { $this->save(); } else { $this->delete(); $this->completed = true; } return $this; } protected function updateDependencies() { $dependencies = (array) $this->dependencies; $total = 0; $downloaded = 0; $installed = 0; foreach ($dependencies['items'] as $dependency) { if (is_object($dependency['instance'])) { $dependency['progress'] = $dependency['instance']->getProgress(); } $total += (int) Moto\Util::getValue($dependency, 'progress.total'); $downloaded += (int) Moto\Util::getValue($dependency, 'progress.downloaded'); $installed += (int) Moto\Util::getValue($dependency, 'progress.installed'); } $dependencies['total'] = $total; $dependencies['downloaded'] = $downloaded; $dependencies['installed'] = $installed; $this->dependencies = $dependencies; } protected function addDependency($dependency) { $instance = null; if ($dependency instanceof Moto\System\Dependency\AbstractDependency) { $instance = $dependency; $dependency = [ 'progress' => $dependency->getProgress(), 'provider' => get_class($dependency), 'attributes' => $dependency->toArray(), ]; } if (!is_array($dependency) || empty($dependency['provider'])) { return false; } $dependency['instance'] = $instance; $dependencies = (array) $this->dependencies; $dependencies['items'][] = $dependency; $this->dependencies = $dependencies; $this->updateDependencies(); return true; } public function executePreparingStep() { $dependency = new Moto\System\Dependency\ThemeMediaLibrary([ 'target' => $this->theme, 'build' => $this->build, ]); if ($dependency->prepareDependencies()) { $this->addDependency($dependency); } $dependency = new Moto\System\Dependency\WebsiteTheme([ 'target' => $this->theme, 'update' => $this->update, ]); if ($dependency->prepareDependencies()) { $this->addDependency($dependency); } $dependency = $this->getFirstDependencyForDownload(); if (!$dependency) { return [ 'next' => 'install', ]; } return true; } protected function getFirstDependencyForDownload() { $dependency = null; $instance = null; $index = null; $dependencies = $this->dependencies; foreach ($dependencies['items'] as $index => $item) { if ($item['progress']['downloaded'] < $item['progress']['total']) { $dependency = $item; break; } } if (!$dependency) { return null; } if (is_object($dependency['instance'])) { return $dependency['instance']; } $class = $dependency['provider']; if (!class_exists($class)) { Moto\System\Log::critical('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Cant create dependency instance', [ 'class' => $class, ]); throw new Moto\Exception('Failed on creating dependency instance'); } $instance = new $class($dependency['attributes']); $dependency['instance'] = $instance; $dependencies['items'][$index] = $dependency; $this->dependencies = $dependencies; return $instance; } public function executeDownloadStep() { $dependency = $this->getFirstDependencyForDownload(); if (!$dependency) { return true; } try { if (!$dependency->downloadDependencies($this->getRecommendedLimits())) { throw new Moto\Exception('Dependency not downloaded'); } } catch (\Exception $e) { if ($e instanceof Moto\System\Exception) { throw $e; } Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Exception "' . $e->getMessage() . '"', [ 'dependency' => [ 'class' => get_class($dependency), ], ]); throw $e; } $dependency = $this->getFirstDependencyForDownload(); if ($dependency) { return [ 'next' => 'download', ]; } return true; } protected function getFirstDependencyForInstall() { $dependency = null; $instance = null; $index = null; $dependencies = $this->dependencies; foreach ($dependencies['items'] as $index => $item) { if ($item['progress']['installed'] < $item['progress']['total']) { $dependency = $item; break; } } if (!$dependency) { return null; } if (is_object($dependency['instance'])) { return $dependency['instance']; } $class = $dependency['provider']; if (!class_exists($class)) { Moto\System\Log::critical('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Cant create dependency instance', [ 'class' => $class, ]); throw new Moto\Exception('Failed on creating dependency instance'); } $instance = new $class($dependency['attributes']); $dependency['instance'] = $instance; $dependencies['items'][$index] = $dependency; $this->dependencies = $dependencies; return $instance; } public function executeInstallStep() { $dependency = $this->getFirstDependencyForInstall(); if (!$dependency) { return true; } try { if (!$dependency->installDependencies($this->getRecommendedLimits())) { throw new Moto\System\Exception('Dependency not installed'); } } catch (\Exception $e) { Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Exception "' . $e->getMessage() . '"', [ 'dependency' => [ 'class' => get_class($dependency), ], ]); throw $e; } $dependency = $this->getFirstDependencyForInstall(); if ($dependency) { return [ 'next' => 'install', ]; } return true; } public function getRecommendedLimits() { return [ 'maxItems' => -1, 'maxTime' => 10, ]; } public function executeCleaningStep() { $dependencies = $this->dependencies; foreach ($dependencies['items'] as $index => $dependency) { $instance = $dependency['instance']; if (!$instance) { $class = $dependency['provider']; if (!class_exists($class)) { Moto\System\Log::critical('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Cant create dependency instance', [ 'class' => $class, ]); throw new Moto\Exception('Failed on creating dependency instance'); } $instance = new $class($dependency['attributes']); $instance->cleaningTemporary(); } } return true; } public function cancelUpdate() { $this->executeCleaningStep(); $this->delete(); return true; } public function fill($attributes) { if (!is_array($attributes)) { return false; } foreach ($attributes as $name => $value) { if (!$this->setAttribute($name, $value)) { return false; } } return true; } public function getAttributes() { return $this->_attributes; } public function setAttribute($name, $value) { $method = 'set' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } $this->_attributes[$name] = $value; return true; } public function getAttribute($name) { $value = Moto\Util::getValue($this->_attributes, $name); $method = 'get' . Moto\Util::toStudlyCase($name) . 'Attribute'; if (method_exists($this, $method)) { return $this->{$method}($value); } return $value; } public function toArray() { $result = []; if (count($this->_visible)) { $attributes = $this->_visible; } else { $attributes = array_keys($this->_attributes); } $attributes = Moto\Util::arrayExcept(array_flip($attributes), $this->_hidden); $attributes = array_keys($attributes); $attributes = array_merge($attributes, $this->_appends); foreach ($attributes as $attribute) { $result[$attribute] = $this->getAttribute($attribute); } return $result; } public function jsonSerialize() { return $this->toArray(); } public function __set($name, $value) { $this->setAttribute($name, $value); } public function __get($name) { return $this->getAttribute($name); } }