<?php
namespace Moto\Application\Users; use Moto\Validator\AbstractValidator; use Moto; class DeleteUserValidator extends AbstractValidator { const BROKEN_SCHEMA = 'brokenSchema'; const USER_NOT_EXISTS = 'userNotExists'; const USER_EMPTY = 'emptyUserId'; const USER_NOT_DIGIT = 'notDigitUserId'; protected $messageTemplates = array( self::BROKEN_SCHEMA => 'Broken request schema', self::USER_NOT_EXISTS => "User '%assignTo%' doesn't exist in database", self::USER_EMPTY => 'User id is empty', self::USER_NOT_DIGIT => "User id - '%assignTo%' is not digit" ); protected $messageVariables = array( 'assignTo' => '_assignTo' ); protected $_assignTo; public function isValid($assignTo, array $context = null) { $this->setValue($assignTo); $isValid = array_key_exists('action', $context); if (!$isValid) { $this->error(self::BROKEN_SCHEMA); } elseif ($context['action'] == 'reassign') { if (empty($assignTo)) { $this->error(self::USER_EMPTY); return false; } $this->_assignTo = is_array($assignTo) ? implode(', ', $assignTo) : $assignTo; $digitsValidator = new \Zend\Validator\Digits(); $isValid = $digitsValidator->isValid($assignTo); if (!$isValid) { $this->error(self::USER_NOT_DIGIT); return false; } $existsValidator = new \Zend\Validator\Db\RecordExists(array( 'table' => Moto\Config::get('database.prefix') . 'users', 'field' => 'id', 'adapter' => Moto\Config::get('databaseAdapter') )); $isValid = $existsValidator->isValid($assignTo); if (!$isValid) { $this->error(self::USER_NOT_EXISTS); } } return $isValid; } }