<?php
namespace Moto\Application\Users; use Moto\Json\Server; use Moto\Json\Request; use Moto\Json\Response; use Moto; class Service extends Moto\Service\AbstractStaticService { protected static $_resourceName = 'users'; protected static $_resourcePrivilegesMap = array( 'getList' => 'get', 'getById' => 'get', 'save' => 'set', ); public static function getList($request = null) { $query = Moto\Database\Models\User::query(); $query->with([ 'role' => function ($query) { $query->addSelect(['id', 'name',]); }, 'language' => function ($query) { $query->addSelect(['id', 'name', 'code', 'locale',]); }, ]); $items = $query->orderBy('name')->get(); $response = new Moto\Json\Response\Collection(); $response->meta->exchangeArray(array( 'total' => $items->count(), 'page' => 1, )); $response->records = $items->toArray(); return $response; } public static function getById($id) { $id = (int) $id; $user = Moto\Database\Models\User::find($id); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } return $user; } public static function save($data = null) { if (null === $data) { $data = static::getRequest()->getParams(); } if (empty($data['id'])) { return static::_addUser($data); } else { return static::_updateUser($data); } } public static function setPassword($request = null) { throw new \Exception('NOT_IMPLEMENTED::' . static::class . '::' . __FUNCTION__); if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new ChangePasswordFilter(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $request = $filter->getValues(); $userTable = new UserTable(); $userTable->useResultAsModel(1); $user = $userTable->getUser($request['id']); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } if (strtolower($user->role_name) === 'root') { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('id' => array('itsRoot'))); } $user->setPassword($request['new_password']); return $userTable->update($user); } public static function delete($request = null) { throw new \Exception('NOT_IMPLEMENTED::' . static::class . '::' . __FUNCTION__); if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new DeleteUserFilter(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $currentUser = Moto\Authentication\Service::getUser(); $user_id = $filter->getValue('user_id'); if (in_array($currentUser->id, $user_id)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('user_id' => array('selfId'))); } $schema = $filter->getValues(); $userTable = new UserTable(); $result = true; $results = array(); $params = $schema; unset($params['user_id']); unset($params['action']); $action = $filter->getValue('action'); foreach ($schema['user_id'] as $userId) { $results[$userId] = true; $user = $userTable->getUser($userId); if (!$user) { $results[$userId] = false; continue; } $results[$userId] = $userTable->deleteUser($user, ($action == 'reassign' ? $filter->getValue('reassign_to') : null)); $result &= $results[$userId]; } return $result; } protected static function _addUser($data) { Moto\System::gate()->authorize('create', Moto\Database\Models\User::class); $filter = new NewUserFilter(); $filter->setData($data); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $user = new Moto\Database\Models\User($values); $user->setPassword($values['password']); if (!$user->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } if ($filter->getValue('send_email')) { Moto\Application\Util\Mailer::sendMailByName('usersAddNew', $user->email, array( 'user' => $user->toArray(), 'password' => $filter->getValue('password'), 'website' => array('adminUrl' => Moto\System::getAbsoluteUrl('@website/mt-admin/'))) ); } return $user; } protected static function _updateUser($data) { $filter = new SaveUserFilter(); $filter->setData($data); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $values = $filter->getValues(); $user = Moto\Database\Models\User::find($values['id']); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } Moto\System::gate()->authorize('update', $user); $currentUser = Moto\Authentication\Service::getUser(); $user_id = (int) $filter->getValue('id'); if ($user_id === (int) $currentUser->id) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('id' => array('selfId'))); } if (strtolower($user->role_name) === 'root') { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('id' => array('itsRoot'))); } $user->fill($values); if (!$user->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } return $user; } public static function setStatus($request = null) { throw new Moto\System\Exception('NOT_IMPLEMENTED::' . static::class . '::' . __FUNCTION__); if (null === $request) { $request = static::getRequest()->getParams(); } $filter = new SetUserStatusFilter(); $filter->setData($request); if (!$filter->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filter->getMessagesKeys()); } $currentUser = Moto\Authentication\Service::getUser(); $user_id = (int) $filter->getValue('user_id'); if ($user_id === (int) $currentUser->id) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, array('user_id' => array('selfId'))); } $user = Moto\Database\Models\User::find($user_id); if (!$user) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NOT_FOUND_MESSAGE, Moto\System\Exception::ERROR_NOT_FOUND_CODE); } $enabled = $filter->getValue('enabled'); if (strtolower($user->role_name) === 'root' && !$enabled) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array('user_id' => array('itsRoot'))); } $user->enabled = $enabled; if (!$user->save()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE); } return $user; } public static function changeRole($request = null) { throw new Moto\System\Exception('NOT_IMPLEMENTED::' . static::class . '::' . __FUNCTION__); if (null === $request) { $request = static::getRequest()->getParams(); } $filterBulk = new ChangeUserRoleBulkFilter(); $filterBulk->setData($request); if (!$filterBulk->isValid()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $filterBulk->getMessagesKeys()); } $usersId = $filterBulk->getValue('user_id'); if (!is_array($usersId)) { $usersId = array($usersId); } $roleId = $filterBulk->getValue('role_id'); $results = array(); $filter = new ChangeUserRoleFilter(); $currentUser = Moto\Authentication\Service::getUser(); for ($i = 0, $icount = count($usersId); $i < $icount; $i++) { $filter->setData(array( 'user_id' => $usersId[$i], 'role_id' => $roleId )); if (!$filter->isValid()) { $results[$usersId[$i]] = array('errors' => $filter->getMessagesKeys()); continue; } $userId = $filter->getValue('user_id'); $user = Moto\Database\Models\User::find($userId); if (!$user) { $results[$usersId[$i]] = array('errors' => array('user_id' => array('noRecordFound'))); continue; } if ($user->role_id === (int) $roleId) { $results[$usersId[$i]] = array('result' => true); continue; } if ($userId === $currentUser->id) { $results[$usersId[$i]] = array('errors' => array('user_id' => array('selfId'))); continue; } if (strtolower($user->role_name) === 'root') { $results[$usersId[$i]] = array('errors' => array('user_id' => array('itsRoot'))); continue; } $user->role_id = $roleId; $results[$usersId[$i]] = array('result' => $user->save()); } return $results; } } 