<?php
namespace Moto\Application\Users; use Moto\Application\Model; use Moto\Application\Model\AbstractModel; use Moto; class UserModel extends AbstractModel { public $id = null; public $login = ''; public $enabled = 1; public $del = 0; protected $_inputFilter = null; protected $_fields = array( 'id' => array(), 'password' => array(), 'salt' => array( 'default' => '' ), 'email' => array(), 'name' => array(), 'role_id' => array(), 'language_id' => array(), 'enabled' => array(), 'created' => array(), 'modified' => array(), 'del' => array(), 'role_name' => array( 'virtual' => true ), 'language_code' => array( 'virtual' => true ), 'language_name' => array( 'virtual' => true ), 'language_locale' => array( 'virtual' => true ), ); public function __construct() { parent::__construct(); $this->created = date('Y-m-d H:i:s'); $this->modified = $this->created; } public function isValidPassword($password) { return Moto\Authentication\Security::verify($password, $this->password, $this->salt); } public function hashPassword($openPassword) { if (empty($this->salt)) { $this->salt = Moto\Authentication\Security::generateSalt(); } $password = Moto\Authentication\Security::hashPassword($openPassword, $this->salt); return $password; } public function setPassword($openPassword) { $this->password = $this->hashPassword($openPassword); } public function getInputFilter() { if (!$this->_inputFilter) { $inputFilter = new InputFilter(); $factory = new InputFactory(); $inputFilter->add($factory->createInput(array( 'name' => 'id', 'required' => true, 'filters' => array( array('name' => 'Moto\Filter\IntValue'), ), ))); $inputFilter->add($factory->createInput(array( 'name' => 'login', 'required' => true, 'filters' => array( array('name' => 'StripTags'), array('name' => 'StringTrim'), ), 'validators' => array( array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => 1, 'max' => 100, ), ), ), ))); $this->_inputFilter = $inputFilter; } return $this->_inputFilter; } } 