<?php
namespace Moto; use Moto; use Zend\Cache\StorageFactory; use Zend\Stdlib\ArrayUtils; class Cache { protected static $_instances = array(); public static function getInstance($name = 'default') { if (!array_key_exists($name, self::$_instances)) { self::$_instances[$name] = self::getCacheEngine($name); } return self::$_instances[$name]; } public static function getCacheEngine($name) { $options = self::getOptionsByName($name); if (empty($options) || empty($options['enabled']) || !$options['enabled']) { $options = self::getOptionsByName('disabled', false); } if (!empty($options['adapter']['options']['cache_dir'])) { $dir = Moto\System::getAbsolutePath($options['adapter']['options']['cache_dir']); $options['adapter']['options']['cache_dir'] = $dir; if (!is_dir($dir)) { Moto\Util::createDir($dir); } } $result = StorageFactory::factory($options); return $result; } public static function getOptionsByName($name = 'default', $useDefaultOptions = true) { $options = Moto\Config::get('cacheEngine.' . $name, array()); if ($useDefaultOptions) { $defaultOptions = Moto\Config::get('cacheEngine.default', array('enabled' => false)); $options = ArrayUtils::merge($defaultOptions, $options); } return $options; } public static function onCacheClean($event = null) { $options = Moto\Config::get('cacheEngine'); if (!is_array($options)) { return; } foreach($options as $name => $value) { if (!empty($value['adapter']['name'])) { if ($value['adapter']['name'] == 'filesystem' && !empty($value['adapter']['options']['cache_dir'])) { $cacheDir = Moto\System::getAbsolutePath($value['adapter']['options']['cache_dir']); if (is_dir($cacheDir)) { Moto\Util::deleteDir($cacheDir, false); } } } } return true; } }