<?php
 namespace Moto; use Moto; class Config { static protected $_data = array(); protected static $_initialized = false; public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::$_data = Moto\System::getConfig(); Moto\Config::set('rootPath', WEBSITE_DIR); } static function get($name = '', $default = null) { if (preg_match('/^path\.(.*)/', $name, $match)) { $new = Moto\System::getRelativePath($match[1]); if (APPLICATION_ENV === 'development') { $old = self::_extractConfig(self::$_data, $name, $default); $log = "\n"; $log .= __CLASS__ . '::' . __FUNCTION__ . "($name)\n"; $trace = debug_backtrace(); $trace = $trace[0]; $log .= $trace['line'] . ' : ' . $trace['file'] . "\n"; $log .= "old :\t$old\n"; $log .= "new :\t$new\n"; $log .= "\n"; if (class_exists('Moto\System\Log', true)) { Moto\System\Log::debug($log); } else { echo $log; } } return $new; } return self::_extractConfig(self::$_data, $name, $default); } static function getPath($name) { $new = Moto\System::getAbsolutePath($name); $old = static::comp_getPath($name); $log = "\n"; $log .= __CLASS__ . '::' . __FUNCTION__ . "($name)\n"; $trace = debug_backtrace(); $trace = $trace[0]; $log .= $trace['line'] . ' : ' . $trace['file'] . "\n"; $log .= "old : $old\n"; $log .= "new : $new\n"; $log .= "\n"; if (class_exists('Moto\System\Log', true)) { Moto\System\Log::debug($log); } else { echo $log; } return $new; } static function comp_getPath($name) { if (empty($name) || !is_string($name)) { return $name; } $namespace = $name; $path = ''; if ($name[0] == '@' && $name != '@') { $pos = strpos($name, '/'); if ($pos) { $namespace = substr($name, 1, $pos - 1); $path = substr($name, $pos); } else { $namespace = substr($name, 1); } } $path = self::get('path.' . $namespace) . $path; $path = Moto\Util::getFullPath($path); return $path; } protected static function _extractConfig($config = array(), $name = '', $default = null) { if (!is_array($config)) { return $default; } if (empty($name)) { return $config; } $depth = substr_count($name, '.'); if ($depth) { $path = explode('.', $name); $key = array_shift($path); $subConfig = isset($config[$key]) ? $config[$key] : $default; if (!is_array($subConfig)) { return $subConfig; } $newName = count($path) > 1 ? implode('.', $path) : $path[0]; return self::_extractConfig($subConfig, $newName, $default); } else { return isset($config[$name]) ? $config[$name] : $default; } } static function set($name, $value = null) { Moto\Util::setToArrayDeep(self::$_data, $name, $value); } static function toArray() { return self::$_data; } public static function getPublic() { $publicConfig = static::$_data; unset($publicConfig['database']); unset($publicConfig['databaseAdapter']); unset($publicConfig['mail']); unset($publicConfig['proxy']); unset($publicConfig['__product_id__']); unset($publicConfig['autoloaderOptions']); unset($publicConfig['rootPath']); unset($publicConfig['renderEngine']); unset($publicConfig['serverRequirements']); unset($publicConfig['systemRecommend']); unset($publicConfig['cacheEngine']); unset($publicConfig['autoloadFiles']); unset($publicConfig['httpClient']); unset($publicConfig['__backend_options__']); unset($publicConfig['__compatibility__']); $publicConfig['path'] = Moto\System::getPaths(); $publicConfig['path'] = array_merge($publicConfig['path'], Moto\System::getUrls()); $publicConfig['path'] = Moto\Util::arrayExcept($publicConfig['path'], array( 'phpLibrary', 'library', 'tempUploads', 'temp', 'updateTemp', 'systemLogDir', 'systemUpdate', 'baseConfigFile', 'userConfigFile', 'websiteSettings', 'install', 'config', 'emailTemplates', 'themeBlocksDataFile', )); if (empty($publicConfig['path']['website'])) { $publicConfig['path']['website'] = '/'; } $info = parse_url($publicConfig['path']['website']); if (!empty($info['path'])) { $publicConfig['path']['website'] = $info['path']; } $publicConfig['__features__'] = Moto\Features::getList(); if(Moto\Authentication\Service::getUser()){ $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); $publicConfig['content_sections'] = $manager->getFrontendConfig(); $databaseInfo = (array) Moto\Util::arrayOnly(Moto\System::getDatabaseInformation(), ['driverName', 'serverVersion']); $databaseInfo['supports'] = array( 'utf8mb4' => Moto\Database\Util::isSupportsCharset('utf8mb4'), ); $publicConfig['environment'] = (object) array( 'php' => (object) array( 'full' => PHP_VERSION, 'id' => PHP_VERSION_ID, 'major' => PHP_MAJOR_VERSION, 'minor' => PHP_MINOR_VERSION, 'dot' => PHP_RELEASE_VERSION, 'upload_max_size' => Moto\Util::convertSizeStringToInteger(min(ini_get('upload_max_filesize'), ini_get('post_max_size'))), ), 'database' => (object) $databaseInfo, ); if (!Moto\Util::getValue(Moto\Website\Settings::get('control_panel_analytics'), 'enabled')) { unset($publicConfig['controlPanelAnalytics']); } $publicConfig['theme'] = Moto\Util::arrayExcept(Moto\Website\Theme::getInfo(), ['features']); } else { unset($publicConfig['externalModules']); unset($publicConfig['controlPanelAnalytics']); } unset($publicConfig['provider']); unset($publicConfig['providers']); return $publicConfig; } } 