<?php
namespace Moto\Database\Export; use Moto; use Illuminate; use PDO; class Util { public static function removeTablePrefix($query, $prefix) { if (!is_string($query) || !is_string($prefix)) { return false; } $prefix = trim($prefix); if ($prefix === '') { return $query; } $query = trim($query); $parts = explode(' ', $query, 2); $action = strtolower($parts[0]); $regexp = null; switch ($action) { case 'drop': $regexp = '/^(DROP TABLE (IF EXISTS )?`)([^`]+)/i'; break; case 'truncate': $regexp = '/^(TRUNCATE TABLE (IF EXISTS )?`)([^`]+)/i'; break; case 'alter': $regexp = '/^(ALTER TABLE (IF EXISTS )?`)([^`]+)/i'; break; case 'create': $regexp = '/^(CREATE TABLE (IF NOT EXISTS )?`)([^`]+)/i'; break; case 'insert': $regexp = '/^(INSERT[\s]*(IGNORE[\s]*)?INTO `)([^`]+)/i'; break; case 'update': $regexp = '/^(UPDATE ()?`)([^`]+)/i'; break; default: return false; } if ($regexp) { $query = preg_replace($regexp, '$1' . $prefix . '$3', $query); } return $query; } public static function sanitizeValues($values, $types, PDO $pdo) { foreach ($values as $index => $value) { if (array_key_exists($index, $types)) { $values[$index] = static::sanitizeValue($value, $types[$index], $pdo); } } return $values; } public static function sanitizeValue($value, $type, PDO $pdo) { if ($value === null) { $value = 'NULL'; } elseif (strpos($type, 'bit') !== false) { throw new Moto\Exception('Unsupported sql type "BIT"'); } elseif (strpos($type, 'binary') !== false || strpos($type, 'blob') !== false) { if (empty($value) || $value === '0') { $value = '\'\''; } else { $value = '0x' . bin2hex($value); } } elseif (is_int($value)) { } else { $value = $pdo->quote($value); } return $value; } public static function removeForeignKeyName($code) { if (!is_string($code)) { return $code; } return preg_replace('/(CONSTRAINT)\s?(`?[^\s`]+`?)\s?(FOREIGN KEY)/iu', '$1 $3', $code); } } 