<?php
 namespace Moto\Database\Metable; use Illuminate; use Moto; class DatabaseMigration { protected static $_tables = [ 'meta_types', 'meta_values', 'meta_relations', ]; protected function createMetaTypesTable($tableName) { $schemaBuilder = $this->getSchemaBuilder(); if ($schemaBuilder->hasTable($tableName)) { return $this->info('Table `' . $tableName . '` already exists'); } $this->info('Creating table `' . $tableName . '`'); $schemaBuilder->create($tableName, function ($table) { $table->increments('id'); $table->string('entity_type', 120); $table->string('property_name', 64); $table->string('property_type', 255)->default('string'); $table->boolean('property_stickable')->default(false); $table->text('property_defaults')->nullable(); $table->timestamps(); $table->unique(['entity_type', 'property_name'], 'entity__property_type'); }); $this->info('Table was created'); return true; } protected function createMetaValuesTable($tableName) { $schemaBuilder = $this->getSchemaBuilder(); if ($schemaBuilder->hasTable($tableName)) { return $this->info('Table `' . $tableName . '` already exists'); } $this->info('Creating table `' . $tableName . '`'); $tablePrefix = (string) $schemaBuilder->getConnection()->getTablePrefix(); if ($tablePrefix !== '') { $tablePrefix = $tablePrefix . '___'; } $schemaBuilder->create($tableName, function ($table) use ($tablePrefix) { $table->increments('id'); $table->unsignedInteger('property_type_id'); $table->longText('property_value')->nullable(); $table->timestamps(); $table->foreign('property_type_id', $tablePrefix . 'foreign__meta_values__meta_types') ->on('meta_types') ->references('id') ->onUpdate('cascade') ->onDelete('cascade'); }); $this->info('Table was created'); return true; } protected function createMetaRelationsTable($tableName) { $schemaBuilder = $this->getSchemaBuilder(); if ($schemaBuilder->hasTable($tableName)) { return $this->info('Table `' . $tableName . '` already exists'); } $this->info('Creating table `' . $tableName . '`'); $tablePrefix = (string) $schemaBuilder->getConnection()->getTablePrefix(); if ($tablePrefix !== '') { $tablePrefix = $tablePrefix . '___'; } $schemaBuilder->create($tableName, function ($table) use ($tablePrefix) { $table->bigIncrements('id'); $table->unsignedInteger('entity_id'); $table->unsignedInteger('property_value_id'); $table->unique(['property_value_id', 'entity_id',], 'property_to_entity'); $table->foreign('property_value_id', $tablePrefix . 'foreign__meta_relations__meta_values') ->on('meta_values') ->references('id') ->onUpdate('cascade') ->onDelete('cascade'); }); $this->info('Table was created'); return true; } protected function getSchemaBuilder() { return Moto\Database\Provider::getSchemaBuilder(); } public function isInstalled() { $schemaBuilder = $this->getSchemaBuilder(); foreach ($this->getTables() as $tableName) { if (!$schemaBuilder->hasTable($tableName)) { return false; } } return true; } public function installIfNeed() { if (!$this->isInstalled()) { $this->install(); } } public function install() { $this->info('Creating tables for meta properties functionality'); $this->createAllTables(); $this->info('Done'); } public function getTables() { return static::$_tables; } protected function info($message, $context = array()) { Moto\System\Log::info('[' . __CLASS__ . '] : ' . $message, $context); return true; } protected function error($message, $context = array()) { Moto\System\Log::error('[' . __CLASS__ . '] : ' . $message, $context); return false; } public function createAllTables() { foreach ($this->getTables() as $tableName) { if (!$this->createTable($tableName)) { return false; } } return true; } public function createTable($tableName) { $method = 'create' . Moto\Util::toStudlyCase($tableName) . 'Table'; if (!method_exists($this, $method)) { $this->error('Method "' . $method . '" is not defined'); return false; } return $this->{$method}($tableName); } } 