<?php
 namespace Moto\Database\Metable; use Illuminate; use Moto; class MetableProvider extends Moto\System\ServiceProvider { const META_TYPE_TABLE_NAME = 'meta_types'; const META_VALUE_TABLE_NAME = 'meta_values'; const META_RELATION_TABLE_NAME = 'meta_relations'; protected $_collection; protected $_entityValuesCollections = []; protected $_typeHandlers = [ 'boolean' => 'DefaultHandler', 'integer' => 'DefaultHandler', 'double' => 'DefaultHandler', 'string' => 'DefaultHandler', 'array' => 'ArrayHandler', 'object' => 'ObjectHandler', ]; public function register() { throw new \RuntimeException('This functionality is not ready yet. See "@Metable : disabled"'); $app = Moto\System::app(); $app->instance(static::class, $this); $app->alias(static::class, 'DatabaseMetableProvider'); } public function boot() { throw new \RuntimeException('This functionality is not ready yet. See "@Metable : disabled"'); if (!Moto\Database\Provider::getSchemaBuilder()->hasTable('meta_types')) { Moto\Update\Upgrade::upgradeForMetaProperties(); } } public function dev_test() { echo __CLASS__ . "\n"; echo 'isRegisteredMetaType(page:test_solo) ' . var_export($this->isRegisteredMetaType(Moto\Database\Models\Page::class, 'test_solo'), true) . "\n"; echo 'isRegisteredMetaType(page:test_not_exists) ' . var_export($this->isRegisteredMetaType($this->resolveEntityClass(Moto\Database\Models\Page::class), 'test_not_exists', 2), true) . "\n"; $this->getTypes(); echo "types count : " . $this->getTypes()->count() . "\n"; $connection = Moto\Database\Provider::getConnection(); $connection->beginTransaction(); $this->registerNewMetaType(Moto\Database\Models\Page::class, 'test_solo1'); echo "types count : " . $this->getTypes()->count() . "\n"; } public function requireMetaTypeHandler($type) { $handler = $this->getMetaTypeHandler($type); if (!$handler) { throw new Moto\Exception('Require handler "' . $type . '" not exists'); } return $handler; } public function getMetaTypeHandler($type) { if (!array_key_exists($type, $this->_typeHandlers)) { return null; } $handler = $this->_typeHandlers[$type]; if ($handler instanceof Moto\Database\Metable\Handlers\AbstractHandler) { return $handler; } if (!is_string($handler)) { return null; } if (!class_exists($handler) && (strpos($handler, '\\') === false)) { $handler = Moto\Database\Metable\Handlers::class . '\\' . $handler; } $handler = Moto\System::app()->make($handler, ['type' => $type]); $this->_typeHandlers[$type] = $handler; return $handler; } public function registerMetaTypeHandler($type, $handler) { if (!is_string($type) || !is_string($handler)) { return false; } $type = trim($type); $handler = trim($handler); if ($type === '' || $handler === '') { return false; } if (array_key_exists($type, $this->_typeHandlers)) { return false; } $this->_typeHandlers[$type] = $handler; return true; } public function getTypes($entity = null) { if (!$this->_collection) { $this->_collection = Moto\Database\Metable\Models\MetaType::query()->get(); } if ($entity === null) { return $this->_collection; } return $this->_collection ->where('entity_type', $this->resolveEntityClass($entity)) ->values(); } public function getType($entity, $name) { return $this->getTypes($entity) ->where('property_name', $name) ->first(); } public function getTypeById($id) { return $this->getTypes() ->where('id', (int) $id) ->first(); } public function resolveEntityClass($entityType) { if (is_object($entityType)) { $entityType = get_class($entityType); } if (!is_string($entityType)) { throw new Moto\Exception('Invalid "entityType"'); } return Moto\Database\Provider::getMorphName($entityType, $entityType); } public function isRegisteredMetaType($entity, $name) { if (!is_string($name)) { throw new Moto\Exception('Invalid "name"'); } return (bool) $this->getType($entity, $name); } public function registerNewMetaType($entity, $name, $type = 'string') { if ($this->isRegisteredMetaType($entity, $name)) { throw new Moto\Exception('Meta type already registered'); } $entity = $this->resolveEntityClass($entity); if (!is_string($name) || !preg_match('/^[a-z][a-z0-9_]{2,63}$/', $name)) { throw new Moto\Exception('Invalid Meta Type Name "' . $name . '"'); } $record = new Moto\Database\Metable\Models\MetaType([ 'entity_type' => $entity, 'property_name' => $name, 'property_type' => $type, ]); if (!$record->save()) { return false; } $this->getTypes()->push($record); return $record; } public function createNewMetaRecord(Moto\Database\BaseModel $entity, $name) { if ($entity->hasMetaProperty($name)) { return false; } $type = $this->getType($entity, $name); if (!$type) { return false; } if (!$entity->exists) { return false; } $meta = $type->values()->make(); $meta->value = $type->getDefaultValue($meta); $meta->save(); $meta->attachToEntity($entity); return $meta; } public function getMetaRelationForEntity(Moto\Database\BaseModel $entity) { $relation = $entity->hasManyThroughMultiplyEntities( Moto\Database\Metable\Models\MetaValue::class, Moto\Database\Metable\Models\MetaRelation::class, 'entity_id', 'id', 'id', 'property_value_id' ); $relation->join( static::META_TYPE_TABLE_NAME, static::META_TYPE_TABLE_NAME . '.id', '=', static::META_VALUE_TABLE_NAME . '.property_type_id' ); $relation->where('meta_types.entity_type', $entity->getMorphClass()); return $relation; } public function getMetaCollectionByEntity(Moto\Database\BaseModel $entity) { if (!$entity->exists) { return false; } $key = $this->resolveEntityClass($entity) . '__' . $entity->id; if (array_key_exists($key, $this->_entityValuesCollections)) { return $this->_entityValuesCollections[$key]; } $relation = $this->getMetaRelationForEntity($entity); $collection = $relation->get(); $collection = $collection->keyBy('name'); $this->_entityValuesCollections[$key] = $collection; return $collection; } } 