<?php
 namespace Moto\Database\Metable\Models; use Illuminate; use Moto; class MetaType extends Moto\Database\BaseModel { protected $table = Moto\Database\Metable\MetableProvider::META_TYPE_TABLE_NAME; protected $fillable = [ 'entity_type', 'property_name', 'property_type', 'property_stickable', 'property_defaults', ]; protected $casts = [ 'property_stickable' => 'boolean', 'property_defaults' => 'array', ]; protected $hidden = [ 'created_at', 'updated_at', ]; public function values() { return $this->hasMany( Moto\Database\Metable\Models\MetaValue::class, 'property_type_id', 'id' ); } public function isSticky() { return $this->property_stickable; } protected function getMetaProvider() { return Moto\System::app('DatabaseMetableProvider'); } public function getDefaultValue(Moto\Database\Metable\Models\MetaValue $meta) { $handler = $this->getMetaProvider()->requireMetaTypeHandler($this->property_type); try { return $handler->getDefaultValue($this, $meta); } catch (\Exception $e) { Moto\System\Log::error('Cant retrieve default value', [ 'metaType' => [ 'id' => $this->id, 'name' => $this->property_name, 'type' => $this->property_type, 'defaults' => $this->property_defaults, ], ]); } return null; } public function isCompatibleValue($value) { return $this->getMetaProvider() ->requireMetaTypeHandler($this->property_type) ->isCompatibleValue($value); } public function encodeValue($value) { $provider = $this->getMetaProvider(); $handler = $provider->requireMetaTypeHandler($this->property_type); return $handler->encodeValue($value); } public function decodeValue($value) { $provider = $this->getMetaProvider(); $handler = $provider->requireMetaTypeHandler($this->property_type); return $handler->decodeValue($value); } public function attachMetaToEntity(Moto\Database\Metable\Models\MetaValue $meta, Moto\Database\BaseModel $entity) { if (!$meta->isSameTypeModel($this)) { Moto\System\Log::debug("Meta Value '{$meta->name}' not compatibility with this Meta Type '{$this->property_type}/{$this->property_name}'"); throw new Moto\Exception('Meta Value is not compatibility with this Type'); } if (!$meta->exists) { return false; } $metaCollection = $entity->getMetaCollection(); if ($metaCollection->has($this->property_name)) { Moto\System\Log::debug("Meta Value '{$meta->name}' already attached to '{$entity->id}'"); return true; } $meta->loadMissing('metaRelations'); $record = $meta->metaRelations()->firstOrNew([ 'entity_id' => $entity->id, 'property_value_id' => $meta->id, ]); if ($record->exists) { Moto\System\Log::debug("Meta Entity Relation already exists for entity:'{$entity->id}' value: '{$this->property_name}' "); return true; } $handler = $this->getMetaProvider()->requireMetaTypeHandler($this->property_type); if ($handler->attaching($meta, $entity) === false) { Moto\System\Log::debug("Meta Handler prevent attaching meta '{$this->property_name}' to '{$entity->id}'"); return false; } if (!$record->save()) { Moto\System\Log::debug("Meta Relation saving failed"); return false; } if (!$handler->saveOnAttach($meta)) { $record->delete(); Moto\System\Log::debug("Meta Value saving failed"); return false; } $relation = $meta->getRelation('metaRelations'); $relation->push($record); $metaCollection->offsetSet($this->property_name, $meta); return true; } public function detachMetaFromEntity(Moto\Database\Metable\Models\MetaValue $meta, Moto\Database\BaseModel $entity) { if (!$meta->isSameTypeModel($this)) { Moto\System\Log::debug("Meta Value '{$meta->name}' not compatibility with this Meta Type '{$this->property_type}/{$this->property_name}'"); throw new Moto\Exception('Meta Value is not compatibility with this Type'); } if (!$meta->exists) { return false; } $handler = $this->getMetaProvider()->getMetaTypeHandler($this->property_type); if ($handler && $handler->detaching($meta, $entity) === false) { Moto\System\Log::debug("Meta Handler prevent detaching meta '{$this->property_name}' from '{$entity->id}'"); return false; } $record = $meta->metaRelations()->where([ 'entity_id' => $entity->id, 'property_value_id' => $meta->id, ])->first(); $entity->getMetaCollection()->offsetUnset($this->property_name); if ($record) { $record->delete(); } else { Moto\System\Log::debug("Meta Entity Relation not exists for entity:'{$entity->id}' value: '{$this->property_type}/{$this->property_name}' "); } if ($handler) { $handler->saveOnDetach($meta); } else { $meta->save(); } return true; } } 