<?php
 namespace Moto\Database\Metable\Models; use Illuminate; use Moto; use RuntimeException; class MetaValue extends Moto\Database\BaseModel { protected static $_instances; protected $table = Moto\Database\Metable\MetableProvider::META_VALUE_TABLE_NAME; protected $_uid; protected $fillable = [ 'value', ]; protected $casts = [ ]; protected $visible = [ 'id', 'uid', 'value', 'name', 'type', ]; protected $hidden = [ 'created_at', 'updated_at', ]; protected $appends = [ 'name', 'value', 'type', 'uid', ]; protected $with = [ 'metaRelations', ]; protected $typeModel; protected $decodedValue; public static function boot() { parent::boot(); $collection = static::getInstancesCollection(); static::saving(function (MetaValue $model) { $model->syncPropertyValue(); }); static::created(function (MetaValue $model) use ($collection) { $collection->offsetSet($model->getKey(), $model); }); static::deleted(function (MetaValue $model) use ($collection) { $collection->offsetUnset($model->getKey()); }); } public static function getInstancesCollection() { if (!static::$_instances) { static::$_instances = new Illuminate\Database\Eloquent\Collection(); } return static::$_instances; } public function newFromBuilder($attributes = [], $connection = null) { $attributes = (array) $attributes; if (!array_key_exists('property_type_id', $attributes)) { throw new RuntimeException('Attribute "property_type_id" is required'); } $propertyType = $this->getMetaProvider()->getTypeById($attributes['property_type_id']); if (!$propertyType) { throw new RuntimeException('Unknown property type with id # ' . $attributes['property_type_id']); } if (!$propertyType->isSticky()) { return parent::newFromBuilder($attributes, $connection); } $primaryKey = $this->getKeyName(); if (!array_key_exists($primaryKey, $attributes)) { throw new RuntimeException('Attribute "' . $primaryKey . '" is required for instanceable'); } $primary = $attributes[$primaryKey]; $collection = static::getInstancesCollection(); if ($collection->offsetExists($primary)) { return $collection->offsetGet($primary); } $model = parent::newFromBuilder($attributes, $connection); $collection->offsetSet($model->getKey(), $model); return $model; } public function setNameAttribute() { return false; } protected function getTypeModel() { if (!$this->typeModel) { $this->typeModel = $this->getMetaProvider() ->getTypes() ->firstWhere('id', $this->property_type_id); } return $this->typeModel; } public function isSameTypeModel(Moto\Database\Metable\Models\MetaType $type) { return ($this->getTypeModel() === $type); } public function getNameAttribute() { return $this->getTypeModel()->property_name; } public function setTypeAttribute() { return false; } public function getTypeAttribute() { return $this->getTypeModel()->property_type; } public function getValueAttribute() { if ($this->decodedValue === null) { $this->decodedValue = $this->getTypeModel() ->decodeValue($this->property_value, $this); } return $this->decodedValue; } public function syncPropertyValue() { $this->attributes['property_value'] = $this->getTypeModel()->encodeValue($this->decodedValue); } public function setValueAttribute($value) { $type = $this->getTypeModel(); if ($type->isCompatibleValue($value)) { $this->decodedValue = $value; $this->syncPropertyValue(); return true; } Moto\System\Log::debug('[' . get_class($this) . '::' . __FUNCTION__ . '] : failed' . "\n" . var_export([ 'name' => $this->name, 'type' => $this->type, 'value' => $value, ], 1) . "\n"); return false; } public function getUidAttribute() { if (!$this->_uid) { $this->_uid = Moto\Util::getUniqueId(); } return $this->_uid; } public function propertyType() { throw new Moto\Exception('Deprecated : ' . __CLASS__ . '::' . __FUNCTION__); return $this->belongsTo( Moto\Database\Metable\Models\MetaType::class, 'property_type_id', 'id' ); } public function metaRelations() { return $this->hasMany( Moto\Database\Metable\Models\MetaRelation::class, 'property_value_id', 'id' ); } protected function getMetaProvider() { return Moto\System::app('DatabaseMetableProvider'); } public function attachToEntity(Moto\Database\BaseModel $entity) { if (!$entity->exists) { return false; } if (!$this->exists) { $this->save(); } return $this->getTypeModel()->attachMetaToEntity($this, $entity); } public function detachFromEntity(Moto\Database\BaseModel $entity) { return $this->getTypeModel()->detachMetaFromEntity($this, $entity); } } 