<?php
 namespace Moto\Database\Metable\Traits; use Illuminate; use Moto; trait MetableTrait { use MetableScopesTrait; protected $_metablePropertyValuesCollection; public static function bootMetableTrait() { static::saved(function (Illuminate\Database\Eloquent\Model $model) { $model->saveAllMetaRecords(); }); static::deleted(function (Illuminate\Database\Eloquent\Model $model) { $model->detachAllMetaRecords(); }); } protected function getMetaProvider() { return Moto\System::app('DatabaseMetableProvider'); } public function getDefinedMetaTypes() { return $this->getMetaProvider()->getTypes($this); } public function getDefinedMetaProperties() { return $this->getDefinedMetaTypes() ->map(function (Moto\Database\Metable\Models\MetaType $type) { return $type->property_name; }) ->values(); } public function getMetaPropertiesAttribute() { if (!$this->_metablePropertyValuesCollection) { $this->_metablePropertyValuesCollection = new Moto\Database\Metable\MetaValueCollection($this->getMetaCollection()); } return $this->_metablePropertyValuesCollection; } public function metaProperties() { return $this->getMetaProvider()->getMetaRelationForEntity($this); } public function hasManyThroughMultiplyEntities($related, $through, $firstKey = null, $secondKey = null, $localKey = null, $secondLocalKey = null) { $through = new $through; if (!$firstKey) { $firstKey = $this->getForeignKey(); } if (!$secondKey) { $secondKey = $through->getForeignKey(); } if (!$localKey) { $localKey = $this->getKeyName(); } if (!$secondLocalKey) { $secondLocalKey = $through->getKeyName(); } return new Moto\Database\Metable\Relations\HasManyThroughMultiplyEntities( $this->newRelatedInstance($related)->newQuery(), $this, $through, $firstKey, $secondKey, $localKey, $secondLocalKey ); } public function setRelation($relation, $value) { if ($relation == 'metaProperties') { $value = $value->keyBy('name'); } return parent::setRelation($relation, $value); } public function getMetaCollection() { if (!$this->relationLoaded('metaProperties')) { $this->setRelation('metaProperties', $this->metaProperties()->get()); } return $this->getRelation('metaProperties'); } public function hasMetaProperty($name) { return $this->getMetaCollection()->has($name); } public function hasMetaRecord($name) { return $this->hasMetaProperty($name); } public function getMetaProperty($name, $default = null) { $record = $this->getMetaRecord($name); if ($record) { return $record->getAttribute('value'); } return $default; } public function getOrCreateMetaProperty($name, $default = null) { $record = $this->getOrCreateMetaRecord($name); if ($record) { return $record->getAttribute('value'); } return $default; } public function getMetaRecord($name) { return $this->getMetaCollection()->get($name); } public function setMetaProperty($name, $value) { $meta = $this->getOrCreateMetaRecord($name); if (!$meta) { return false; } $meta->value = $value; $meta->save(); return true; } public function unsetMetaProperty($name) { if (is_array($name)) { foreach ($name as $key) { $this->unsetMetaProperty($key); } return true; } $meta = $this->getMetaRecord($name); if (!$meta) { return true; } return $meta->detachFromEntity($this); } public function getOrCreateMetaRecord($name) { $meta = $this->getMetaRecord($name); if (!$meta) { $meta = $this->createNewMetaRecord($name); } return $meta; } public function createNewMetaRecord($name) { return $this->getMetaProvider()->createNewMetaRecord($this, $name); } public function attachMetaRecord(Moto\Database\Metable\Models\MetaValue $value) { return $value->attachToEntity($this); } public function detachMetaRecord(Moto\Database\Metable\Models\MetaValue $value) { return $value->detachFromEntity($this); } public function detachAllMetaRecords() { foreach ($this->getMetaCollection() as $meta) { $meta->detachFromEntity($this); } } public function saveAllMetaRecords() { foreach ($this->getMetaCollection() as $meta) { if ($meta->isDirty()) { $meta->save(); } } } public function syncMetaProperties($input, $detaching = true) { $changes = [ 'attached' => [], 'detached' => [], 'updated' => [], 'ignored' => [], ]; $verbose = false; $currentMetaProperties = $this->getMetaCollection(); $definedMetaProperties = $this->getDefinedMetaProperties()->all(); $inputProperties = array_keys($input); $changes['ignored'] = array_diff($inputProperties, $definedMetaProperties); $toRemoveIfDetaching = array_diff($currentMetaProperties->keys()->all(), $inputProperties); if ($verbose) { echo '$toSyncMetaProperties  : ' . implode(', ', array_keys($input)) . "\n"; echo '$definedMetaProperties : ' . implode(', ', $definedMetaProperties) . "\n"; echo '$currentMetaProperties : ' . implode(', ', $currentMetaProperties->keys()->all()) . "\n"; echo '$toRemoveIfDetaching => ' . implode(', ', $toRemoveIfDetaching) . "\n"; echo '$unknownMetaProperties => ' . implode(', ', $changes['ignored']) . "\n"; } if ($detaching && count($toRemoveIfDetaching)) { if ($verbose) { echo "Detach mode enabled : will remove " . count($toRemoveIfDetaching) . " meta properties\n"; } foreach ($toRemoveIfDetaching as $name) { $meta = $this->getMetaRecord($name); if ($verbose) { echo "\tDetach '$name' from page # {$this->id}\n"; } $meta->detachFromEntity($this); $changes['detached'][] = $name; } } if ($verbose) { echo "Attaching meta properties\n"; } foreach ($input as $name => $value) { if (in_array($name, $changes['ignored'])) { if ($verbose) { echo "\tProperty '{$name}' not registered - ignored\n"; } continue; } $meta = $this->getMetaRecord($name); if ($verbose) { echo "\tProperty '{$name}' "; } if ($meta) { $changes['updated'][] = $name; if ($verbose) { echo "updating\n"; } } else { $meta = $this->createNewMetaRecord($name); $changes['attached'][] = $name; if ($verbose) { echo " create new\n"; } } $meta->value = $value; $meta->save(); } return $changes; } } 