<?php
 namespace Moto\Database\Models; use Illuminate; use Illuminate\Database\Eloquent\Relations; use Moto; use Moto\Database\Scope; use Zend; class ContentTaxonomy extends Moto\Database\BaseModel implements Moto\System\ContentSection\HasContentProviderInterface { const TAXONOMY_TYPE = null; protected $table = 'content_taxonomies'; protected $morphClass = '@ContentTaxonomy'; protected $fillable = [ 'name', 'slug', 'type', 'attraction_level', 'parent_id', 'group_id', 'short_description', 'long_description', 'properties', ]; protected $casts = [ 'id' => 'int', 'name' => 'string', 'slug' => 'string', 'type' => 'string', 'assigned_targets_count' => 'int', 'published_targets_count' => 'int', 'pages_count' => 'int', 'published_pages_count' => 'int', 'blog_posts_count' => 'int', 'attraction_level' => 'int', 'parent_id' => 'int', 'group_id' => 'int', 'short_description' => 'string', 'long_description' => 'string', 'properties' => 'object', ]; protected $attributes = [ 'name' => '', 'slug' => '', 'type' => '', 'assigned_count' => 0, 'attraction_level' => 0, 'parent_id' => 0, 'group_id' => 0, 'short_description' => '', 'long_description' => '', 'properties' => '{}', ]; protected $visible = [ ]; protected $hidden = [ 'pivot', 'assigned_count', ]; protected $dates = [ ]; protected static $_cache = []; protected $_definition; public function __construct(array $attributes = []) { if (static::TAXONOMY_TYPE) { $this->attributes['type'] = static::TAXONOMY_TYPE; } parent::__construct($attributes); } public static $usePolymorphicModel = false; public function newFromBuilder($attributes = [], $connection = null) { if (!static::$usePolymorphicModel) { return parent::newFromBuilder($attributes, $connection); } $model = $this->newInstance(Illuminate\Support\Arr::only((array) $attributes, ['type']), true); $model->setRawAttributes((array) $attributes, true); $model->setConnection($connection ?: $this->getConnectionName()); $model->fireModelEvent('retrieved', false); return $model; } public function newInstance($attributes = [], $exists = false) { if (!static::$usePolymorphicModel) { return parent::newInstance($attributes, $exists); } $model = null; $meta = $this->getMetaType('*', Moto\Util::getValue($attributes, 'type')); if (!empty($meta['content'])) { $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); $provider = $manager->getProvider($meta['content']); if ($provider) { $class = $provider->getWebsiteApplication()->getTaxonomyClass($meta['taxonomy']); if (!empty($class)) { $model = new $class((array) $attributes); } } } if (!empty($model)) { $model = new static((array) $attributes); } $model->exists = $exists; $model->setConnection( $this->getConnectionName() ); return $model; } public static function boot() { parent::boot(); if (static::TAXONOMY_TYPE) { static::addGlobalScope(new Scope\SimpleGlobalScope(function ($builder, $model) { $builder->where('type', '=', static::TAXONOMY_TYPE); })); } } public function assignedTargets() { return $this->pages(); } public function publishedTargets() { return Moto\Database\Models\Page::addPublishedPageCondition($this->assignedTargets()); } public function pages() { throw new \RuntimeException('Method not allowed for used'); } public function publishedPages() { return Moto\Database\Models\Page::addPublishedPageCondition($this->pages()); } public function getMetaType($name = null, $type = null) { if ($type === null) { $type = $this->attributes['type']; } if (empty($type)) { return null; } if (!array_key_exists($type, static::$_cache)) { static::$_cache[$type] = [ 'content' => null, 'section' => null, 'taxonomy' => null, 'tail' => null, ]; if (preg_match('/^(?<section>[^.]+)(\.(?<taxonomy>[^.]+))(?<tail>.*)$/', $this->type, $match)) { static::$_cache[$type] = [ 'content' => $match['section'], 'section' => $match['section'], 'taxonomy' => $match['taxonomy'], 'tail' => $match['tail'], ]; } } if (!$name || $name === '*') { return static::$_cache[$type]; } return Moto\Util::getValue(static::$_cache[$type], $name); } public function getSectionName() { return $this->getMetaType('section'); } public function getInnerType() { return $this->getMetaType('taxonomy'); } protected function getWebsiteApplication() { $provider = $this->getContentProvider(); if ($provider) { return $provider->getWebsiteApplication(); } return null; } public function getDefinition() { if (!$this->_definition) { $this->_definition = $this->getContentProvider() ->getTaxonomyDefinition($this->getInnerType()); } return $this->_definition; } public function getContentProvider() { $name = $this->getMetaType('content'); $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); return $manager->getProvider($name); } public function getParentPage() { return $this->getContentProvider() ->getWebsiteApplication() ->getMainPage(); } public function getAbsoluteUrl($query = null) { $app = $this->getWebsiteApplication(); if (!$app) { return null; } $url = $app->getAbsoluteUrl($this); if (!empty($query)) { $url = Moto\Util::extendUrl($url, array('query' => $query), array('query' => 'join')); } return $url; } public function getRelativeUrl($query = null) { $app = $this->getWebsiteApplication(); if (!$app) { return null; } $url = $app->getRelativeUrl($this); if (!empty($query)) { $url = Moto\Util::extendUrl($url, array('query' => $query), array('query' => 'join')); } return $url; } } 