<?php
 namespace Moto\Database\Models; use Moto; class MediaItem extends Moto\Database\BaseModel { const CREATED_AT = 'created'; const UPDATED_AT = 'modified'; protected $table = 'media_items'; protected $_legacyModel = Moto\Application\MediaLibrary\MediaItemModel::class; protected $fillable = [ 'folder_id', 'name', 'path', 'type', 'filesize', 'properties', 'thumbnails', 'title', 'caption', 'alt', 'author_id', 'is_protected', 'basename', ]; protected $casts = [ 'folder_id' => 'int', 'name' => 'string', 'path' => 'string', 'type' => 'string', 'filesize' => 'int', 'properties' => 'object', 'thumbnails' => 'object', 'title' => 'string', 'caption' => 'string', 'alt' => 'string', 'author_id' => 'int', 'is_protected' => 'boolean', ]; protected $attributes = [ 'folder_id' => 0, 'name' => '', 'path' => '', 'type' => 'file', 'properties' => '[]', 'thumbnails' => '{}', 'title' => '', 'caption' => '', 'alt' => '', ]; protected $appends = [ 'basename', ]; public function getBasenameAttribute() { return pathinfo($this->name, PATHINFO_FILENAME); } public function setBasenameAttribute($value) { $this->name = $value . '.' . pathinfo($this->name, PATHINFO_EXTENSION); return true; } } 