<?php
 namespace Moto\Database\Models; use Moto; use Illuminate; class Page extends Moto\Database\BaseModel implements Moto\System\ContentSection\HasContentProviderInterface { const EXTENDER_CLASS = Moto\Database\Extendable\Extender::class; use Moto\Database\Extendable\ExtendableModelTrait; const CREATED_AT = 'created'; const UPDATED_AT = 'modified'; const STATUS__PUBLISH = 'publish'; const STATUS__DRAFT = 'draft'; const VISIBILITY__PUBLIC = 'public'; const VISIBILITY__PASSWORD = 'password'; const VISIBILITY__PROTECTED = 'password'; const VISIBILITY__PRIVATE = 'private'; use Moto\Database\Traits\PageModelTrait; protected $table = 'pages'; protected $morphClass = '@Page'; protected $fillable = [ ]; protected $casts = [ 'id' => 'int', 'author_id' => 'int', 'parent_id' => 'int', 'category_id' => 'int', 'is_system' => 'int', 'properties' => 'object', 'layout' => 'object', ]; protected $attributes = [ ]; protected $visible = [ 'id', 'name', 'url', 'title', 'author_id', 'parent_id', 'category_id', 'is_system', 'content', 'type', 'status', 'visibility', 'properties', 'layout', 'styles', 'background', 'background_id', 'short_description', 'published', 'modified', 'created', 'tags', 'category', 'taxonomies', ]; protected $with = [ ]; protected $appends = [ ]; protected $hidden = [ 'pivot', ]; protected $dates = [ 'published', ]; public function __construct(array $attributes = []) { $this->applyExtendsOnConstructing(); parent::__construct($attributes); $this->applyExtendsOnConstructed(); } public static function boot() { parent::boot(); static::deleted(function ($model) { $model->taxonomies()->detach(); $model->closureTreeAncestor()->delete(); $model->closureTreeDescendant()->delete(); }); } public function tags() { return $this->belongsToMany( ContentTaxonomyTag::class, 'content_taxonomy_relations', 'target_id', 'taxonomy_id'); } public function taxonomies() { return $this->belongsToMany( ContentTaxonomyTag::class, 'content_taxonomy_relations', 'target_id', 'taxonomy_id'); } public function category() { return $this->belongsTo( ContentTaxonomyCategory::class, 'category_id', 'id'); } public function author() { return $this->belongsTo( User::class, 'author_id', 'id'); } public function parentPage() { return $this->hasOne(static::class, 'id', 'parent_id'); } public function getContentProvider() { return Moto\Website\PageType::get($this->type)->getContentProvider(); } public function getParentPage($columns = ['*']) { if (!$this->parent_id) { return null; } return $this->parentPage()->first($columns); } public static function addPublishedPageCondition($query) { if ($query instanceof Illuminate\Database\Eloquent\Builder || $query instanceof Illuminate\Database\Eloquent\Relations\Relation) { $query->where('published', '<=', date('Y-m-d H:i:s', time())); $query->where('status', '=', Moto\Application\Pages\PageModel::STATUS_PUBLISH); } return $query; } } 