<?php
 namespace Moto\Database; use Illuminate; use Moto; use Zend; class Provider { const DEFAULT_ENGINE = 'InnoDB'; const DEFAULT_CHARSET = 'utf8mb4'; const DEFAULT_COLLATE_POSTFIX = '_unicode_ci'; const SYSTEM_TABLES = [ 'content_blocks', 'jobs_pool' => [ 'dump' => ['structure'], ], 'job_tasks' => [ 'dump' => ['structure'], ], 'content_taxonomies', 'content_taxonomy_relations', 'fonts', 'languages', 'media_folders', 'media_items', 'menus', 'menu_items', 'pages', 'pages_treepath', 'presets', 'roles', 'settings', 'styles', 'users', ]; protected static $_initialized = false; protected static $_schemaBuilder; protected static $_databaseCapsule; public static function getDefaultConnectionName() { return 'default'; } public static function getDatabaseCapsule() { if (!static::$_databaseCapsule) { static::$_databaseCapsule = new Illuminate\Database\Capsule\Manager(); static::$_databaseCapsule->setAsGlobal(); } return static::$_databaseCapsule; } public static function initEloquent(Zend\Db\Adapter\Adapter $ZendAdapter, $databaseConfig = null, $eventDispatcher = null) { if (static::$_initialized) { return false; } if (!is_array($databaseConfig)) { $databaseConfig = Moto\Config::get('database'); } if (!is_array($databaseConfig)) { throw new Moto\Exception('Bad database config, must be array'); } if (empty($databaseConfig['hostname'])) { throw new Moto\Exception('Config parameters "hostname" is empty'); } if (empty($databaseConfig['database'])) { throw new Moto\Exception('Config parameters "database" is empty'); } $charset = Moto\Util::getValue($databaseConfig, 'charset', 'utf8'); $config = [ 'driver' => 'mysql', 'host' => $databaseConfig['hostname'], 'database' => $databaseConfig['database'], 'username' => Moto\Util::getValue($databaseConfig, 'username', ''), 'password' => Moto\Util::getValue($databaseConfig, 'password', ''), 'charset' => $charset, 'prefix' => Moto\Util::getValue($databaseConfig, 'prefix', ''), 'collation' => $charset . '_unicode_ci', ]; $PDOConnection = $ZendAdapter->getDriver()->getConnection()->getResource(); $capsule = static::getDatabaseCapsule(); $databaseManager = $capsule->getDatabaseManager(); $databaseManager->extend(static::getDefaultConnectionName(), function ($config, $name) use ($PDOConnection) { return new Illuminate\Database\MySqlConnection($PDOConnection, $config['database'], $config['prefix'], $config); }); $capsule->addConnection($config); $capsule->addConnection($config, 'export'); if (!($eventDispatcher instanceof Illuminate\Events\Dispatcher)) { $eventDispatcher = Moto\System::getEventDispatcher(); } $capsule->setEventDispatcher($eventDispatcher); static::addMorphMap([ '@Page' => Moto\Database\Models\Page::class, '@BlogPost' => Moto\Module\Blog\Models\BlogPost::class, '@ContentTaxonomyCategory' => Models\ContentTaxonomyCategory::class, '@ContentTaxonomyTag' => Models\ContentTaxonomyTag::class, '@ContentTaxonomyOne' => Models\ContentTaxonomyCategory::class, '@ContentTaxonomyMany' => Models\ContentTaxonomyTag::class, ]); $capsule->bootEloquent(); static::$_initialized = true; return true; } public static function getMorphMap() { return Illuminate\Database\Eloquent\Relations\Relation::morphMap(); } public static function addMorphMap(array $map) { Illuminate\Database\Eloquent\Relations\Relation::morphMap($map); return true; } public static function getMorphName($class, $default = null) { $morphMap = static::getMorphMap(); if (in_array($class, $morphMap, true)) { return array_search($class, $morphMap, true); } return $default; } public static function getMorphClass($name, $default = null) { $morphMap = static::getMorphMap(); if (array_key_exists($name, $morphMap)) { return $morphMap[$name]; } return $default; } public static function getConnection($name = 'default') { return static::getDatabaseCapsule()->getConnection($name); } public static function getSchemaBuilder() { if (!static::$_initialized) { throw new Moto\Exception('Eloquent not initialized'); } if (!static::$_schemaBuilder) { static::$_schemaBuilder = Illuminate\Database\Capsule\Manager::schema(); } return static::$_schemaBuilder; } public static function getTablePrefix() { return Moto\Config::get('database.prefix'); } public static function getSystemTables() { return static::SYSTEM_TABLES; } } class Page extends Moto\Database\Models\Page { } class PageClosure extends Moto\Database\Models\PageClosure { } 