<?php
 namespace Moto\Filter; use Moto; use Illuminate; use InvalidArgumentException; class UniqueDatabaseValue extends Moto\Filter\AbstractFilter { protected $_options = [ 'query' => null, 'column' => null, 'suffix' => '-', 'startIndex' => 1, 'maxIteration' => 255, ]; protected $_lastIndex; public function setQuery($value = null) { if ($value instanceof Illuminate\Database\Eloquent\Builder) { $this->_options['query'] = $value; return $this; } throw new InvalidArgumentException('Option "query" : invalid value'); } public function setColumn($value) { if (!is_string($value)) { throw new InvalidArgumentException('Option "column" : value is not a string'); } $value = trim($value); if (!preg_match('/^[a-z0-9\-_]+$/', $value)) { throw new InvalidArgumentException('Option "column" : invalid value "' . $value . '"'); } $this->_options['column'] = $value; return $this; } public function setSuffix($value) { if (!is_string($value)) { throw new InvalidArgumentException('Option "suffix" : value is not a string'); } if ($value !== '' && !preg_match('/^[a-z0-9\-_]+$/', $value)) { throw new InvalidArgumentException('Option "suffix" : invalid value "' . $value . '"'); } $this->_options['suffix'] = $value; return $this; } public function setStartIndex($value) { if (!is_int($value)) { throw new InvalidArgumentException('Option "maxIteration" : value is not a int'); } $this->_options['startIndex'] = $value; return $this; } public function setMaxIteration($value) { if (!is_int($value)) { throw new InvalidArgumentException('Option "maxIteration" : value is not a int'); } if ($value < 1) { throw new InvalidArgumentException('Option "maxIteration" : value must be great 0'); } $this->_options['maxIteration'] = $value; return $this; } public function getLastIndex() { return $this->_lastIndex; } public function filter($value) { $this->_lastIndex = null; if (!is_string($value)) { return null; } $query = $this->getOption('query'); if (!$query) { throw new InvalidArgumentException('Option "query" is required'); } $column = $this->getOption('column'); if (!$column) { throw new InvalidArgumentException('Option "column" is required'); } $check = clone $query; $check->where($column, $value); if (!$check->exists()) { return $value; } $currentIndex = $this->getOption('startIndex'); $suffix = $this->getOption('suffix'); $maxIteration = $this->getOption('maxIteration'); for ($i = 0; $i < $maxIteration + 1; $i++) { $this->_lastIndex = $currentIndex; $newValue = $value . $suffix . $currentIndex; $check = clone $query; $check->where($column, $newValue); if (!$check->exists()) { return $newValue; } $currentIndex++; } return null; } } 